﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakeVisualStudioProject.Converter
{
    public class OptionDefinition
    {
        public string Switch { get; private set; }

        public string MetadataName { get; private set; }
        public string MetadataValue { get; private set; }

        public bool AcceptsArgument { get; private set; }
        public bool IsArgumentRequired { get; private set; }

        public string ArgumentName { get; private set; }

        [YamlDotNet.Serialization.YamlIgnore()]
        public bool HasArgumentName
        {
            get
            {
                return !string.IsNullOrEmpty(ArgumentName);
            }
        }

        public string Separator { get; private set; }
        public string ArgumentSeparator { get; private set; }

        [YamlDotNet.Serialization.YamlIgnore()]
        public bool AcceptsMultipleArguments
        {
            get
            {
                return !string.IsNullOrEmpty(ArgumentSeparator);
            }
        }

        public bool ShouldSeparateSwitchAndArguments { get; private set; }

        public OptionDefinition()  // YamlDotNet の Deserialize 用
        {
        }
        public OptionDefinition(string s, string mn, string mv)
            : this(s, mn, mv, false, false, null, null, null)
        {
        }
        public OptionDefinition(string s, string mn, string mv, bool a, bool requiresArg = false, string argName = null, string separator = null, string argSeparator = null)
        {
            Switch = s?.TrimEnd(' ');
            MetadataName = mn;
            MetadataValue = mv;
            AcceptsArgument = a;
            IsArgumentRequired = requiresArg;
            ArgumentName = argName;
            Separator = separator;
            ArgumentSeparator = argSeparator;
            ShouldSeparateSwitchAndArguments = s?.EndsWith(" ") ?? false;
        }

        public override string ToString()
        {
            return string.Format("Switch = {0} | Name = {1}, Value = {2}", Switch, MetadataName, MetadataValue);
        }
    }
}
