﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakeVisualStudioProject.Converter
{
    public class NXOptionDefinitionGenerator
    {
        public static IEnumerable<OptionDefinition> GetCompilerOptionDefinitions(string platform, string vcToolsVersion = null, string vsVersion = null)
        {
            return GenerateOptionDefinitions(platform, "cl.xml", vcToolsVersion, vsVersion);
        }

        public static IEnumerable<OptionDefinition> GetLibrarianOptionDefinitions(string platform, string vcToolsVersion = null, string vsVersion = null)
        {
            return GenerateOptionDefinitions(platform, "lib.xml", vcToolsVersion, vsVersion);
        }

        public static IEnumerable<OptionDefinition> GetLinkerOptionDefinitions(string platform, string vcToolsVersion = null, string vsVersion = null)
        {
            return GenerateOptionDefinitions(platform, "link.xml", vcToolsVersion, vsVersion);
        }

        private static IEnumerable<OptionDefinition> GenerateOptionDefinitions(string platform, string filename, string vcToolsVersion = null, string vsVersion = null)
        {
            var vcv = vcToolsVersion ?? "14.0";
            var vsv = vsVersion ?? "140";

            var vcTargetsPath = OptionDefinitionGenerator.GetVCTargetsPath(vcv, vsv);
            var lcid = System.Globalization.CultureInfo.InstalledUICulture.LCID.ToString();
            var xmlPath = Path.Combine(vcTargetsPath, "Platforms", platform, "props", lcid, filename);

            try
            {
                return OptionDefinitionGenerator.Generate(xmlPath);
            }
            catch (Exception ex)
            {
                if (ex is FileNotFoundException || ex is DirectoryNotFoundException)
                {
                    throw new OptionGenerationException(
                        "NX ツールチェインのコマンドラインオプション定義を生成できません。Oasis for NX がインストールされていることを確認してください。", ex);
                }
                else
                {
                    throw;
                }
            }
        }
    }
}
