﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakeSampleSolution
{
    internal class SolutionProject
    {
        public ProjectFile ProjectFile { get; private set; }

        public IEnumerable<SolutionProject> Dependencies { get; private set; }
        public Guid SolutionFolderGuid { get; private set; }

        public SolutionProject(
            string path,
            IEnumerable<SolutionProject> dependencies,
            Guid solutionFolderGuid)
        {
            ProjectFile = new ProjectFile(path);
            Dependencies = dependencies;
            SolutionFolderGuid = solutionFolderGuid;
        }

        public static IEnumerable<SolutionProject> ReadSolutionProjects(SolutionSetting solutionSetting)
        {
            var solutionProjects = solutionSetting.Projects.ToDictionary(x => x.Path, x =>
            {
                return new SolutionProject(x.Path, null, solutionSetting.GetSolutionFolderGuid(x.SolutionFolderPath));
            });

            foreach (var project in solutionSetting.Projects)
            {
                if (project.Dependencies != null)
                {
                    solutionProjects[project.Path].Dependencies = project.Dependencies.Select(x => solutionProjects[x.Path]);
                }
                else
                {
                    solutionProjects[project.Path].Dependencies = Enumerable.Empty<SolutionProject>();
                }
            }

            return solutionProjects.Values;
        }
    }
}
