﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Definition.StaticLibrary
{
    [System.ComponentModel.Composition.Export(typeof(IStaticLibraryDefinition))]
    class libnn_utilTool : IStaticLibraryDefinition
    {
        public string Name => "libnn_utilTool";

        public bool RequestsAddedToAdditionalDependencies(ReleaseIntent intent) =>
            (intent.Spec == Constants.Spec.Generic
                || intent.Spec == Constants.Spec.NX)
            &&
            (intent.Deliverable == Constants.Deliverable.Sdk);

        public string GetAdditionalDependenciesCondition(ReleaseIntent intent) => Constants.Condition.PlatformWin32OrX64;
    }
}
