﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Definition.StaticLibrary
{
    [System.ComponentModel.Composition.Export(typeof(IStaticLibraryDefinition))]
    class libnn_hws : IStaticLibraryDefinition
    {
        public string Name => "libnn_hws";

        public bool RequestsAddedToAdditionalDependencies(ReleaseIntent intent) =>
            (intent.Spec == Constants.Spec.Generic
                || intent.Spec == Constants.Spec.NX)
            &&
            (intent.Deliverable == Constants.Deliverable.Application
                || intent.Deliverable == Constants.Deliverable.Sdk
                || intent.Deliverable == Constants.Deliverable.SdkSample);

        public string GetAdditionalDependenciesCondition(ReleaseIntent intent) => Constants.Condition.PlatformWin32OrX64;
    }
}
