﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Definition.StaticLibrary
{
    // TODO: Ocean が新方式のリンカオプション生成器を利用できる準備が整ったら削除
    [System.ComponentModel.Composition.Export(typeof(IStaticLibraryDefinition))]
    class libc__abi : IStaticLibraryDefinition
    {
        public string Name => "libc++abi";

        public bool RequestsAddedToAdditionalDependencies(ReleaseIntent intent) =>
            intent.Spec == Constants.Spec.NX
            &&
            intent.PublishSystemProgramSettings;

        public string GetAdditionalDependenciesCondition(ReleaseIntent intent) =>
            $"{Constants.Condition.PlatformNX32OrNX64} and {Constants.Condition.NintendoSdkProgramKindSystemProgramOrApplicationWithoutSdkNso}"
            + " and '$(NintendoSdkUseUnifiedLinkCommandLineGenerator)'!='true'";
    }
}
