﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.Target
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class NintendoSdkCheckProjectConfigurationValidity : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            switch (ctx.Intent.Deliverable)
            {
                case Constants.Deliverable.Sdk:
                case Constants.Deliverable.SdkSample:
                case Constants.Deliverable.SdkTest:
                    // nact で自動生成されたプロジェクトに必要
                    yield return new ProjectTarget("NintendoSdkCheckProjectConfigurationValidity", null, null, "PrepareForBuild",
                        new ProjectErrorTask(
                            "プロジェクト構成 '$(Configuration)|$(Platform)' は適切なビルド設定が行われていないため、ビルドできません。別の構成を選択してください。このプロジェクトに関連するソリューションファイルが存在する場合は、ソリューションファイルを使用してビルドしてください。",
                            "'$(_NintendoSdkIsUnsupportedProjectConfiguration)'=='true' and '$(LangID)'=='1041'"),
                        new ProjectErrorTask(
                            "Cannot build with project configuration '$(Configuration)|$(Platform)' because it is not properly configured. Please choose another configuration. If you have a solution file corresponding to this project, please perform build from the solution file.",
                            "'$(_NintendoSdkIsUnsupportedProjectConfiguration)'=='true' and '$(LangID)'!='1041'"));
                    break;
                case Constants.Deliverable.Application:
                    // 不要
                    break;
                default:
                    ReportUnexpectedDeliverable(ctx);
                    break;
            }
        }
    }
}
