﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.Property
{
    // TODO: 不要にできるはず

    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class _NintendoSdkSdkLibraryName : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            if (ctx.Intent.Spec != Constants.Spec.NX)
            {
                yield break;
            }

            if (ctx.Intent.PublishSystemProgramSettings)
            {
                // 空であるか確認するのは Ocean との互換性のため
                yield return new ProjectPropertyGroup($"{Constants.Condition.PlatformNX32OrNX64} and '$(_NintendoSdkSdkLibraryName)'==''",
                    new ProjectProperty("_NintendoSdkSdkLibraryName", "nnSdk", "'$(NintendoSdkBuildType)'=='Release'"),
                    new ProjectProperty("_NintendoSdkSdkLibraryName", "nnSdkJp", "'$(NintendoSdkBuildType)'!='Release' and '$(LangName)'=='ja-JP'"),
                    new ProjectProperty("_NintendoSdkSdkLibraryName", "nnSdkEn", "'$(NintendoSdkBuildType)'!='Release' and '$(LangName)'!='ja-JP'"),
                    new ProjectProperty("_NintendoSdkSdkLibraryName", "nnSdkEmpty", "'$(_NintendoSdkProgramKind)'=='ApplicationWithoutSdkNso'"));
            }
            else
            {
                yield return new ProjectPropertyGroup(Constants.Condition.PlatformNX32OrNX64,
                    new ProjectProperty("_NintendoSdkSdkLibraryName", "nnSdk", "'$(NintendoSdkBuildType)'=='Release'"),
                    new ProjectProperty("_NintendoSdkSdkLibraryName", "nnSdkJp", "'$(NintendoSdkBuildType)'!='Release' and '$(LangName)'=='ja-JP'"),
                    new ProjectProperty("_NintendoSdkSdkLibraryName", "nnSdkEn", "'$(NintendoSdkBuildType)'!='Release' and '$(LangName)'!='ja-JP'"));
            }
        }
    }
}
