﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.Property
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class OutDir : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            switch (ctx.Intent.BuildEnvironment)
            {
                case Constants.BuildEnvironment.Repository:
                    switch (ctx.Intent.Deliverable)
                    {
                        case Constants.Deliverable.Sdk:
                            yield return new ProjectProperty("OutDir",
                                @"$(NintendoSdkSubDevelopmentRoot)Libraries\$(NintendoSdkBuildTarget)\$(NintendoSdkBuildType)\",
                                Constants.Condition.ConfigurationTypeLibrary);
                            yield return new ProjectProperty("OutDir",
                                @"$(NintendoSdkSubDevelopmentRoot)Outputs\$(NintendoSdkBuildTarget)\$(NintendoSdkProgramCategory)\$(TargetName)\$(NintendoSdkBuildType)\",
                                Constants.Condition.ConfigurationTypeApplication);
                            break;
                        case Constants.Deliverable.SdkSample:
                            yield return new ProjectProperty("OutDir",
                                @"$(NintendoSdkRoot)Samples\Libraries\$(NintendoSdkBuildTarget)\$(NintendoSdkBuildType)\",
                                Constants.Condition.ConfigurationTypeLibrary);
                            yield return new ProjectProperty("OutDir",
                                @"$(NintendoSdkRoot)Samples\Outputs\$(NintendoSdkBuildTarget)\Applications\$(TargetName)\$(NintendoSdkBuildType)\",
                                Constants.Condition.ConfigurationTypeApplication);
                            break;
                        case Constants.Deliverable.SdkTest:
                            yield return new ProjectProperty("OutDir",
                                @"$(NintendoSdkRoot)Tests\Libraries\$(NintendoSdkBuildTarget)\$(NintendoSdkBuildType)\",
                                Constants.Condition.ConfigurationTypeLibrary);
                            yield return new ProjectProperty("OutDir",
                                @"$(NintendoSdkRoot)Tests\Outputs\$(NintendoSdkBuildTarget)\Tests\$(TargetName)\$(NintendoSdkBuildType)\",
                                Constants.Condition.ConfigurationTypeApplication);
                            break;
                        case Constants.Deliverable.Application:
                            // 不要
                            break;
                        default:
                            ReportUnexpectedDeliverable(ctx);
                            break;
                    }
                    break;
                case Constants.BuildEnvironment.Package:
                    switch (ctx.Intent.Deliverable)
                    {
                        case Constants.Deliverable.Sdk:
                            yield return new ProjectProperty("OutDir",
                                @"$(NintendoSdkRoot)Libraries\$(NintendoSdkBuildTarget)\$(NintendoSdkBuildType)\",
                                Constants.Condition.ConfigurationTypeLibrary);
                            yield return new ProjectProperty("OutDir",
                                @"$(NintendoSdkRoot)Outputs\$(NintendoSdkBuildTarget)\$(NintendoSdkProgramCategory)\$(TargetName)\$(NintendoSdkBuildType)\",
                                Constants.Condition.ConfigurationTypeApplication);
                            break;
                        case Constants.Deliverable.SdkSample:
                            yield return new ProjectProperty("OutDir",
                                @"$(NintendoSdkRoot)Samples\Libraries\$(NintendoSdkBuildTarget)\$(NintendoSdkBuildType)\",
                                Constants.Condition.ConfigurationTypeLibrary);
                            yield return new ProjectProperty("OutDir",
                                @"$(ProjectDir)Binaries\$(Platform)\$(Configuration)\",
                                Constants.Condition.ConfigurationTypeApplication);
                            break;
                        case Constants.Deliverable.SdkTest:
                            // ？
                            break;
                        case Constants.Deliverable.Application:
                            // 不要
                            break;
                        default:
                            ReportUnexpectedDeliverable(ctx);
                            break;
                    }
                    break;
                default:
                    ReportUnexpectedBuildEnvironment(ctx);
                    break;
            }
        }
    }
}
