﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.Property
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class NintendoSdkUseUnifiedLinkCommandLineGenerator : ProjectElementConstructor
    {
        const string OasisSupportsUnifiedLinkCommandLineGenerator = "('$(OasisMajor)'!='' and '$(OasisMinor)'!='' and ($(OasisMajor) > 4 or ($(OasisMajor) == 4 and $(OasisMinor) >= 3)))";

        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            if (ctx.Intent.Spec != Constants.Spec.NX)
            {
                yield break;
            }

            // TODO: Ocean が新方式のリンカオプション生成器を利用できる準備が整ったら削除
            if (ctx.Intent.BuildEnvironment == Constants.BuildEnvironment.Package
                && ctx.Intent.Deliverable == Constants.Deliverable.Application
                && ctx.Intent.PublishSystemProgramSettings)
            {
                yield return new ProjectProperty(
                    "NintendoSdkUseUnifiedLinkCommandLineGenerator", "false",
                        // Ocean 側でプロパティを上書きできるようにしておく
                        $"'$(NintendoSdkUseUnifiedLinkCommandLineGenerator)'==''"
                        + $" and {Constants.Condition.PlatformNX32OrNX64}"
                        + $" and ("
                            // SystemProgram のビルドの場合はデフォルトで旧方式を採用 (Ocean のビルド環境移行期間確保のため)
                            + $"({Constants.Condition.ConfigurationTypeApplication} and {Constants.Condition.NintendoSdkProgramKindSystemProgram})"
                            // もしくは Oasis が新方式をサポートしていない場合は旧方式を採用 (false にしておかないと旧方式用のプロパティやメタデータが定義されないため)
                            + $" or !{OasisSupportsUnifiedLinkCommandLineGenerator})");

                yield return new ProjectProperty(
                    "NintendoSdkUseUnifiedLinkCommandLineGenerator", "true",
                        $"'$(NintendoSdkUseUnifiedLinkCommandLineGenerator)'==''"
                        + $" and {Constants.Condition.PlatformNX32OrNX64}"
                        // SystemProgram のビルドでない (= Application, ApplicationWithoutSdkNso, NRO) かつ Oasis が新方式をサポートしている場合は新方式を採用
                        + $" and !("
                            + $"({Constants.Condition.ConfigurationTypeApplication} and {Constants.Condition.NintendoSdkProgramKindSystemProgram})"
                            + $" or !{OasisSupportsUnifiedLinkCommandLineGenerator})");
            }
            else
            {
                // デフォルトで新方式のリンカオプション生成器を採用
                yield return new ProjectProperty(
                    "NintendoSdkUseUnifiedLinkCommandLineGenerator", "true",
                    $"{Constants.Condition.PlatformNX32OrNX64} and {OasisSupportsUnifiedLinkCommandLineGenerator}");

                // 新方式を使用できない場合、プロパティシート側で旧方式用のプロパティやメタデータが定義されるようにする
                // 新方式を使用できるのは Oasis 4.3 からなので、Oasis 4.2 (を含む SDK) のサポートが終了したら削除可能？
                yield return new ProjectProperty(
                    "NintendoSdkUseUnifiedLinkCommandLineGenerator", "false",
                    $"{Constants.Condition.PlatformNX32OrNX64} and !{OasisSupportsUnifiedLinkCommandLineGenerator}");
            }
        }
    }
}
