﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.Property
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class NintendoSdkSpecFilesDirectory : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            switch (ctx.Intent.BuildEnvironment)
            {
                case Constants.BuildEnvironment.Repository:
                    yield return new ProjectProperty("NintendoSdkSpecFilesDirectory", @"$(NintendoSdkRoot)Programs\Iris\Resources\SpecFiles\");
                    break;
                case Constants.BuildEnvironment.Package:
                    yield return new ProjectProperty("NintendoSdkSpecFilesDirectory", @"$(NintendoSdkRoot)Resources\SpecFiles\");
                    break;
                default:
                    ReportUnexpectedBuildEnvironment(ctx);
                    break;
            }
        }
    }
}
