﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.Property
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class NintendoSdkBuildTarget : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            switch (ctx.Intent.Spec)
            {
                case Constants.Spec.Generic:
                    yield return new ProjectProperty("NintendoSdkBuildTarget", "Win32-v120", "'$(Platform)'=='Win32' and '$(PlatformToolset)'=='v120'");
                    yield return new ProjectProperty("NintendoSdkBuildTarget", "Win32-v140", "'$(Platform)'=='Win32' and '$(PlatformToolset)'=='v140'");
                    yield return new ProjectProperty("NintendoSdkBuildTarget", "Win32-v141", "'$(Platform)'=='Win32' and '$(PlatformToolset)'=='v141'");
                    yield return new ProjectProperty("NintendoSdkBuildTarget", "Win32-v141_clang_c2", "'$(Platform)'=='Win32' and '$(PlatformToolset)'=='v141_clang_c2'");
                    yield return new ProjectProperty("NintendoSdkBuildTarget", "x64-v120", "'$(Platform)'=='x64' and '$(PlatformToolset)'=='v120'");
                    yield return new ProjectProperty("NintendoSdkBuildTarget", "x64-v140", "'$(Platform)'=='x64' and '$(PlatformToolset)'=='v140'");
                    yield return new ProjectProperty("NintendoSdkBuildTarget", "x64-v141", "'$(Platform)'=='x64' and '$(PlatformToolset)'=='v141'");
                    yield return new ProjectProperty("NintendoSdkBuildTarget", "x64-v141_clang_c2", "'$(Platform)'=='x64' and '$(PlatformToolset)'=='v141_clang_c2'");
                    break;
                case Constants.Spec.Cafe:
                    yield return new ProjectProperty("NintendoSdkBuildTarget", "CafeOnWin32", "'$(Platform)'=='Win32' and '$(PlatformToolset)'=='v110'");
                    yield return new ProjectProperty("NintendoSdkBuildTarget", "Cafe", "'$(Platform)'=='Cafe'");
                    break;
                case Constants.Spec.NX:
                    yield return new ProjectProperty("NintendoSdkBuildTarget", "NX-Win32-v120", "'$(Platform)'=='Win32' and '$(PlatformToolset)'=='v120'");
                    yield return new ProjectProperty("NintendoSdkBuildTarget", "NX-Win32-v140", "'$(Platform)'=='Win32' and '$(PlatformToolset)'=='v140'");
                    yield return new ProjectProperty("NintendoSdkBuildTarget", "NX-Win32-v141", "'$(Platform)'=='Win32' and '$(PlatformToolset)'=='v141'");
                    yield return new ProjectProperty("NintendoSdkBuildTarget", "NX-Win32-v141_clang_c2", "'$(Platform)'=='Win32' and '$(PlatformToolset)'=='v141_clang_c2'");
                    yield return new ProjectProperty("NintendoSdkBuildTarget", "NX-x64-v120", "'$(Platform)'=='x64' and '$(PlatformToolset)'=='v120'");
                    yield return new ProjectProperty("NintendoSdkBuildTarget", "NX-x64-v140", "'$(Platform)'=='x64' and '$(PlatformToolset)'=='v140'");
                    yield return new ProjectProperty("NintendoSdkBuildTarget", "NX-x64-v141", "'$(Platform)'=='x64' and '$(PlatformToolset)'=='v141'");
                    yield return new ProjectProperty("NintendoSdkBuildTarget", "NX-x64-v141_clang_c2", "'$(Platform)'=='x64' and '$(PlatformToolset)'=='v141_clang_c2'");
                    yield return new ProjectProperty("NintendoSdkBuildTarget", "NX-NXFP2-a32", "'$(Platform)'=='NX32'");
                    yield return new ProjectProperty("NintendoSdkBuildTarget", "NX-NXFP2-a64", "'$(Platform)'=='NX64'");
                    break;
                default:
                    ReportUnexpectedSpec(ctx);
                    break;
            }
        }
    }
}
