﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.Property
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class IntDir : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            switch (ctx.Intent.BuildEnvironment)
            {
                case Constants.BuildEnvironment.Repository:
                    switch (ctx.Intent.Deliverable)
                    {
                        case Constants.Deliverable.Sdk:
                            yield return new ProjectProperty("IntDir",
                                @"$(NintendoSdkSubDevelopmentRoot)Intermediates\$(NintendoSdkBuildTarget)\Libraries\$(TargetName)\$(NintendoSdkBuildType)\",
                                Constants.Condition.ConfigurationTypeLibrary);
                            yield return new ProjectProperty("IntDir",
                                @"$(NintendoSdkSubDevelopmentRoot)Intermediates\$(NintendoSdkBuildTarget)\$(NintendoSdkProgramCategory)\$(TargetName)\$(NintendoSdkBuildType)\",
                                Constants.Condition.ConfigurationTypeApplication);
                            break;
                        case Constants.Deliverable.SdkSample:
                            yield return new ProjectProperty("IntDir",
                                @"$(NintendoSdkRoot)Samples\Intermediates\$(NintendoSdkBuildTarget)\Libraries\$(TargetName)\$(NintendoSdkBuildType)\",
                                Constants.Condition.ConfigurationTypeLibrary);
                            yield return new ProjectProperty("IntDir",
                                @"$(NintendoSdkRoot)Samples\Intermediates\$(NintendoSdkBuildTarget)\Applications\$(TargetName)\$(NintendoSdkBuildType)\",
                                Constants.Condition.ConfigurationTypeApplication);
                            break;
                        case Constants.Deliverable.SdkTest:
                            yield return new ProjectProperty("IntDir",
                                @"$(NintendoSdkRoot)Tests\Intermediates\$(NintendoSdkBuildTarget)\Libraries\$(TargetName)\$(NintendoSdkBuildType)\",
                                Constants.Condition.ConfigurationTypeLibrary);
                            yield return new ProjectProperty("IntDir",
                                @"$(NintendoSdkRoot)Tests\Intermediates\$(NintendoSdkBuildTarget)\Tests\$(TargetName)\$(NintendoSdkBuildType)\",
                                Constants.Condition.ConfigurationTypeApplication);
                            break;
                        case Constants.Deliverable.Application:
                            // 不要
                            break;
                        default:
                            ReportUnexpectedDeliverable(ctx);
                            break;
                    }
                    break;
                case Constants.BuildEnvironment.Package:
                    switch (ctx.Intent.Deliverable)
                    {
                        case Constants.Deliverable.Sdk:
                            yield return new ProjectProperty("IntDir",
                                @"$(NintendoSdkRoot)Intermediates\$(NintendoSdkBuildTarget)\Libraries\$(TargetName)\$(NintendoSdkBuildType)\",
                                Constants.Condition.ConfigurationTypeLibrary);
                            yield return new ProjectProperty("IntDir",
                                @"$(NintendoSdkRoot)Intermediates\$(NintendoSdkBuildTarget)\$(NintendoSdkProgramCategory)\$(TargetName)\$(NintendoSdkBuildType)\",
                                Constants.Condition.ConfigurationTypeApplication);
                            break;
                        case Constants.Deliverable.SdkSample:
                            yield return new ProjectProperty("IntDir",
                                @"$(NintendoSdkRoot)Samples\Intermediates\$(NintendoSdkBuildTarget)\Libraries\$(TargetName)\$(NintendoSdkBuildType)\",
                                Constants.Condition.ConfigurationTypeLibrary);
                            yield return new ProjectProperty("IntDir",
                                @"$(ProjectDir)Objects\$(Platform)\$(Configuration)\",
                                Constants.Condition.ConfigurationTypeApplication);
                            break;
                        case Constants.Deliverable.SdkTest:
                            // ？
                            break;
                        case Constants.Deliverable.Application:
                            // 不要
                            break;
                        default:
                            ReportUnexpectedDeliverable(ctx);
                            break;
                    }
                    break;
                default:
                    ReportUnexpectedBuildEnvironment(ctx);
                    break;
            }
        }
    }
}
