﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.Property
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class DynamicSymbolList : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            if (ctx.Intent.Spec != Constants.Spec.NX)
            {
                yield break;
            }

            // NINTENDOSDK-3356
            // Oasis 2.0.0 のリリースまでは、暫定的に \ を / に置換して Rynda にパスが適切に渡るようにする
            yield return new ProjectPropertyGroup(Constants.Condition.PlatformNX32OrNX64,
                new ProjectProperty("DynamicSymbolList", @"$([System.Text.RegularExpressions.Regex]::Replace($(NintendoSdkSpecFilesDirectory), '\\', '/'))ExportDynamicSymbol.lst"));
        }
    }
}
