﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.ItemDefinition.PostLink
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class StripSymbolStrings : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            if (ctx.Intent.Spec != Constants.Spec.Cafe)
            {
                yield break;
            }

            yield return new ProjectItemDefinition("PostLink", Constants.Condition.PlatformCafe,
                new ProjectMetadata("StripSymbolStrings", "false", Constants.Condition.NintendoSdkBuildTypeDebug),
                new ProjectMetadata("StripSymbolStrings", "true", Constants.Condition.NintendoSdkBuildTypeDevelopOrRelease));
        }
    }
}
