﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.ItemDefinition.Link
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class SubSystem : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            switch (ctx.Intent.Deliverable)
            {
                case Constants.Deliverable.Sdk:
                    // デフォルトは設定せず
                    break;
                case Constants.Deliverable.SdkSample:
                case Constants.Deliverable.SdkTest:
                    yield return new ProjectItemDefinition("Link", Constants.Condition.PlatformWin32OrX64,
                        new ProjectMetadata("SubSystem", "Console", Constants.Condition.ConfigurationTypeApplication));
                    break;
                case Constants.Deliverable.Application:
                    // 不要
                    break;
                default:
                    ReportUnexpectedDeliverable(ctx);
                    break;
            }
        }
    }
}
