﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.ItemDefinition.Link
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class StaticOptions : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            if (ctx.Intent.Spec != Constants.Spec.NX)
            {
                yield break;
            }

            // Application
            {
                var commonOptions = new[]
                {
                    "-nostartfiles",
                    "-Wl,--gc-sections",
                    "-Wl,-init=_init,-fini=_fini",
                    "-Wl,-pie",
                    "-Wl,-z,combreloc,-z,relro,--enable-new-dtags",
                };
                var nx32Options = new[]
                {
                    "-Wl,--target2=got-rel",
                };

                yield return new ProjectItemDefinition(
                    "Link",
                    $"{Constants.Condition.ConfigurationTypeApplication} and {Constants.Condition.NintendoSdkProgramKindApplication}",
                        new ProjectMetadata("StaticOptions", string.Join(" ", commonOptions), Constants.Condition.PlatformNX64),
                        new ProjectMetadata("StaticOptions", string.Join(" ", commonOptions.Concat(nx32Options)), Constants.Condition.PlatformNX32));
            }
            // SystemProgram
            if (ctx.Intent.PublishSystemProgramSettings)
            {
                var commonOptions = new[]
                {
                    "-nostartfiles",
                    "-Wl,--gc-sections",
                    "-Wl,-init=_init,-fini=_fini",
                    "-Wl,-pie",
                    "-Wl,-e,_start",
                };
                var nx32Options = new[]
                {
                    "-Wl,--target2=got-rel",
                };

                yield return new ProjectItemDefinition(
                    "Link",
                    $"{Constants.Condition.ConfigurationTypeApplication} and {Constants.Condition.NintendoSdkProgramKindSystemProgram}",
                        new ProjectMetadata("StaticOptions", string.Join(" ", commonOptions), Constants.Condition.PlatformNX64),
                        new ProjectMetadata("StaticOptions", string.Join(" ", commonOptions.Concat(nx32Options)), Constants.Condition.PlatformNX32));
            }
            // ApplicationWithoutSdkNso
            if (ctx.Intent.PublishSystemProgramSettings)
            {
                var commonOptions = new[]
                {
                    "-nostartfiles",
                    "-Wl,--gc-sections",
                    "-Wl,-init=_init,-fini=_fini",
                    "-Wl,-pie",
                    "-Wl,-z,combreloc,-z,relro,--enable-new-dtags",
                };
                var nx32Options = new[]
                {
                    "-Wl,--target2=got-rel",
                };

                yield return new ProjectItemDefinition(
                    "Link",
                    $"{Constants.Condition.ConfigurationTypeApplication} and {Constants.Condition.NintendoSdkProgramKindApplicationWithoutSdkNso}",
                        new ProjectMetadata("StaticOptions", string.Join(" ", commonOptions), Constants.Condition.PlatformNX64),
                        new ProjectMetadata("StaticOptions", string.Join(" ", commonOptions.Concat(nx32Options)), Constants.Condition.PlatformNX32));
            }
            // NRO
            {
                var commonOptions = new[]
                {
                    "-nostartfiles",
                    "-Wl,--gc-sections",
                    "-Wl,-init=_init,-fini=_fini",
                    "-Wl,-shared",
                    "-Wl,--whole-archive",
                    "-Wl,-z,combreloc,-z,relro,--enable-new-dtags",
                };
                var nx32Options = new[]
                {
                    "-Wl,--target2=got-rel",
                };

                yield return new ProjectItemDefinition(
                    "Link",
                    Constants.Condition.ConfigurationTypeDynamicLibrary,
                        new ProjectMetadata("StaticOptions", string.Join(" ", commonOptions), Constants.Condition.PlatformNX64),
                        new ProjectMetadata("StaticOptions", string.Join(" ", commonOptions.Concat(nx32Options)), Constants.Condition.PlatformNX32));
            }
        }
    }
}
