﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.ItemDefinition.Link
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class SdkRuntimeDependencies : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            if (ctx.Intent.Spec != Constants.Spec.NX)
            {
                yield break;
            }

            // Application
            {
                yield return new ProjectItemDefinition(
                    "Link",
                    $"{Constants.Condition.ConfigurationTypeApplication} and {Constants.Condition.NintendoSdkProgramKindApplication}",
                        new ProjectMetadata("SdkRuntimeDependencies", "rocrt.o;nn$(_NintendoSdkProgramKind).o", Constants.Condition.PlatformNX32OrNX64));
            }
            // SystemProgram, ApplicationWithoutSdkNso
            if (ctx.Intent.PublishSystemProgramSettings)
            {
                yield return new ProjectItemDefinition(
                    "Link",
                    $"{Constants.Condition.ConfigurationTypeApplication} and {Constants.Condition.NintendoSdkProgramKindApplicationWithoutSdkNso}",
                        new ProjectMetadata("SdkRuntimeDependencies", "rocrt.o;nn$(_NintendoSdkProgramKind).o", Constants.Condition.PlatformNX32OrNX64));
                yield return new ProjectItemDefinition(
                    "Link",
                    $"{Constants.Condition.ConfigurationTypeApplication} and {Constants.Condition.NintendoSdkProgramKindSystemProgram}",
                        new ProjectMetadata("SdkRuntimeDependencies", "rocrt.o;nnrtld.o;nn$(_NintendoSdkProgramKind).o", Constants.Condition.PlatformNX32OrNX64));
            }
            // NRO
            {
                yield return new ProjectItemDefinition(
                    "Link",
                    Constants.Condition.ConfigurationTypeDynamicLibrary,
                        new ProjectMetadata("SdkRuntimeDependencies", "rocrt_nro.o", Constants.Condition.PlatformNX32OrNX64));
            }
        }
    }
}
