﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.ItemDefinition.Link
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class LinkerType : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            if (ctx.Intent.Spec != Constants.Spec.NX)
            {
                yield break;
            }

            switch (ctx.Intent.Deliverable)
            {
                case Constants.Deliverable.Application:
                    {
                        yield return new ProjectItemDefinition("Link", Constants.Condition.PlatformNX32OrNX64,
                            new ProjectMetadata("LinkerType", "LLDLinker"));
                    }
                    break;
                case Constants.Deliverable.Sdk:
                case Constants.Deliverable.SdkSample:
                case Constants.Deliverable.SdkTest:
                    {
                        yield return new ProjectItemDefinition("Link", Constants.Condition.PlatformNX32OrNX64,
                            new ProjectMetadata("LinkerType", "GoldLinker"));
                    }
                    break;
                default:
                    ReportUnexpectedDeliverable(ctx);
                    break;
            }
        }
    }
}
