﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.ItemDefinition.Link
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class LinkerScript : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            if (ctx.Intent.Spec != Constants.Spec.NX)
            {
                yield break;
            }

            // Application
            {
                if (ctx.Intent.PublishSystemProgramSettings)
                {
                    yield return new ProjectItemDefinition("Link", Constants.Condition.ConfigurationTypeApplication,
                        new ProjectMetadata("LinkerScript", "$(NintendoSdkSpecFilesDirectory)Application.arm.ilp32.ldscript",
                            $"{Constants.Condition.PlatformNX32} and {Constants.Condition.NintendoSdkProgramKindApplicationOrApplicationWithoutSdkNso}"),
                        new ProjectMetadata("LinkerScript", "$(NintendoSdkSpecFilesDirectory)Application.aarch64.lp64.ldscript",
                            $"{Constants.Condition.PlatformNX64} and {Constants.Condition.NintendoSdkProgramKindApplicationOrApplicationWithoutSdkNso}"),
                        new ProjectMetadata("LinkerScript", "$(NintendoSdkSpecFilesDirectory)SystemProgram.arm.ilp32.ldscript",
                            $"{Constants.Condition.PlatformNX32} and {Constants.Condition.NintendoSdkProgramKindSystemProgram}"),
                        new ProjectMetadata("LinkerScript", "$(NintendoSdkSpecFilesDirectory)SystemProgram.aarch64.lp64.ldscript",
                            $"{Constants.Condition.PlatformNX64} and {Constants.Condition.NintendoSdkProgramKindSystemProgram}"));
                }
                else
                {
                    yield return new ProjectItemDefinition("Link", Constants.Condition.ConfigurationTypeApplication,
                        new ProjectMetadata("LinkerScript", "$(NintendoSdkSpecFilesDirectory)Application.arm.ilp32.ldscript",
                            Constants.Condition.PlatformNX32),
                        new ProjectMetadata("LinkerScript", "$(NintendoSdkSpecFilesDirectory)Application.aarch64.lp64.ldscript",
                            Constants.Condition.PlatformNX64));
                }
            }
            // DynamicLibrary
            {
                yield return new ProjectItemDefinition("Link", Constants.Condition.ConfigurationTypeDynamicLibrary,
                    new ProjectMetadata("LinkerScript", "$(NintendoSdkSpecFilesDirectory)RoModule.arm.ilp32.ldscript",
                        Constants.Condition.PlatformNX32),
                    new ProjectMetadata("LinkerScript", "$(NintendoSdkSpecFilesDirectory)RoModule.aarch64.lp64.ldscript",
                        Constants.Condition.PlatformNX64));
            }
        }
    }
}
