﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.ItemDefinition.Link
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class LinkTimeCodeGeneration : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            switch (ctx.Intent.BuildEnvironment)
            {
                case Constants.BuildEnvironment.Repository:
                    // nact ビルド時は incremental LTCG を使用しない
                    {
                        yield return new ProjectItemDefinition("Link", Constants.Condition.PlatformWin32OrX64,
                            new ProjectMetadata("LinkTimeCodeGeneration", "UseLinkTimeCodeGeneration",
                                "'$(NintendoSdkBuildByInternalTool)'=='true' and '%(Link.LinkTimeCodeGeneration)'=='UseFastLinkTimeCodeGeneration'"));
                    }
                    break;
                case Constants.BuildEnvironment.Package:
                    // 不要？
                    break;
                default:
                    ReportUnexpectedBuildEnvironment(ctx);
                    break;
            }
        }
    }
}
