﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.ItemDefinition.Link
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class AuthoringUserCommand : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            if (ctx.Intent.Spec != Constants.Spec.NX)
            {
                yield break;
            }
            if (!ctx.Intent.PublishSystemProgramSettings)
            {
                yield break;
            }

            yield return new ProjectItemDefinition("Link", $"{Constants.Condition.ConfigurationTypeApplication} and {Constants.Condition.NintendoSdkProgramKindSystemProgram}",
                new ProjectMetadata("AuthoringUserCommand",
                    @"%(AuthoringUserCommand) --keyconfig $(NintendoSdkAuthoringToolKeyConfigFile)",
                    $"{Constants.Condition.PlatformNX32OrNX64} and '$(NintendoSdkAuthoringToolKeyConfigFile)'!=''"));
            yield return new ProjectItemDefinition("Link", $"{Constants.Condition.ConfigurationTypeApplication} and {Constants.Condition.NintendoSdkProgramKindSystemProgram}",
                new ProjectMetadata("AuthoringUserCommand",
                    @"%(AuthoringUserCommand) --keyindex $(NintendoSdkAuthoringToolKeyIndex)",
                    $"{Constants.Condition.PlatformNX32OrNX64} and '$(NintendoSdkAuthoringToolKeyIndex)'!=''"));
        }
    }
}
