﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.ItemDefinition.Link
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class AdditionalSearchDependencies : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            if (ctx.Intent.Spec != Constants.Spec.NX)
            {
                yield break;
            }

            if (ctx.Intent.PublishSystemProgramSettings)
            {
                yield return new ProjectItemDefinition(
                    "Link",
                    $"{Constants.Condition.ConfigurationTypeApplication} and {Constants.Condition.NintendoSdkProgramKindApplication}",
                        new ProjectMetadata("AdditionalSearchDependencies", string.Empty, Constants.Condition.PlatformNX32OrNX64));
                yield return new ProjectItemDefinition(
                    "Link",
                    $"{Constants.Condition.ConfigurationTypeApplication} and {Constants.Condition.NintendoSdkProgramKindSystemProgramOrApplicationWithoutSdkNso}",
                        new ProjectMetadata("AdditionalSearchDependencies", "c++;c++abi;unwind;compiler_rt;c;shim", Constants.Condition.PlatformNX32OrNX64));
                yield return new ProjectItemDefinition(
                    "Link",
                    Constants.Condition.ConfigurationTypeDynamicLibrary,
                        new ProjectMetadata("AdditionalSearchDependencies", string.Empty, Constants.Condition.PlatformNX32OrNX64));
            }
            else
            {
                yield return new ProjectItemDefinition(
                    "Link",
                    Constants.Condition.PlatformNX32OrNX64,
                        new ProjectMetadata("AdditionalSearchDependencies", string.Empty));
            }
        }
    }
}
