﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.ItemDefinition.Link
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class AdditionalDependencies : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            var composer = new Definition.StaticLibraryDefinitionComposer(Program.CompositionContainer);
            var definitions = composer.StaticLibraryDefinitions;

            var libraries = new Dictionary<string, List<string>>();

            foreach (var definition in definitions)
            {
                if (!definition.RequestsAddedToAdditionalDependencies(ctx.Intent))
                {
                    continue;
                }

                var condition = definition.GetAdditionalDependenciesCondition(ctx.Intent);

                if (!libraries.ContainsKey(condition))
                {
                    libraries.Add(condition, new List<string>());
                }
                libraries[condition].Add(definition.Name);
            }

            foreach (var condition in libraries.Keys)
            {
                yield return new ProjectItemDefinition("Link", condition,
                    new ProjectMetadata("AdditionalDependencies",
                        string.Join(
                            ";",
                            libraries[condition].Select(x => $"{x}$(NintendoSdkLibSuffix)").Concat(new[] { "%(AdditionalDependencies)" })),
                            Constants.Condition.ConfigurationTypeApplication));
            }

            switch (ctx.Intent.Spec)
            {
                case Constants.Spec.Generic:
                    break;
                case Constants.Spec.NX:
                    yield return ConstructNXSdkLibraryDependency(ctx);
                    break;
                case Constants.Spec.Cafe:
                    break;
                default:
                    ReportUnexpectedSpec(ctx);
                    break;
            }
        }

        private ProjectElement ConstructNXSdkLibraryDependency(ConstructionContext ctx)
        {
            // TODO: 本来 AdditionalDependencies に入れるべきではない
            if (ctx.Intent.PublishSystemProgramSettings)
            {
                return new ProjectItemDefinition("Link", Constants.Condition.PlatformNX32OrNX64,
                    new ProjectMetadata("AdditionalDependencies",
                        "$(_NintendoSdkSdkLibraryName).nss;%(AdditionalDependencies)",
                        $"{Constants.Condition.ConfigurationTypeApplication} and '$(_NintendoSdkUseSdkLibrary)'=='true'"));
            }
            else
            {
                return new ProjectItemDefinition("Link", Constants.Condition.PlatformNX32OrNX64,
                    new ProjectMetadata("AdditionalDependencies",
                        "$(_NintendoSdkSdkLibraryName).nss;%(AdditionalDependencies)",
                        Constants.Condition.ConfigurationTypeApplication));
            }
        }
    }
}
