﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.ItemDefinition.ClCompile
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class RuntimeTypeInfo : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            if (ctx.Intent.Spec != Constants.Spec.NX)
            {
                yield break;
            }

            switch (ctx.Intent.Deliverable)
            {
                case Constants.Deliverable.Sdk:
                case Constants.Deliverable.SdkSample:
                case Constants.Deliverable.SdkTest:
                    yield return new ProjectItemDefinition("ClCompile", Constants.Condition.PlatformNX32OrNX64,
                        new ProjectMetadata("RuntimeTypeInfo", "true"));
                    break;
                case Constants.Deliverable.Application:
                    yield return new ProjectItemDefinition("ClCompile", Constants.Condition.PlatformNX32OrNX64,
                        new ProjectMetadata("RuntimeTypeInfo", "false"));
                    break;
                default:
                    ReportUnexpectedDeliverable(ctx);
                    break;
            }
        }
    }
}
