﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.ItemDefinition.ClCompile
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class OmitFramePointers : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            yield return new ProjectItemDefinition("ClCompile", $"{Constants.Condition.PlatformWin32OrX64} and {Constants.Condition.PlatformToolsetUseClang}",
                new ProjectMetadata("OmitFramePointers", "false", Constants.Condition.NintendoSdkBuildTypeDebugOrDevelop),
                new ProjectMetadata("OmitFramePointers", "true", Constants.Condition.NintendoSdkBuildTypeRelease));
        }
    }
}
