﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.MakePropertySheets.Constructor.ItemDefinition.ClCompile
{
    [System.ComponentModel.Composition.Export(typeof(ProjectElementConstructor))]
    class DebugInformationFormat : ProjectElementConstructor
    {
        public override IEnumerable<ProjectElement> Construct(ConstructionContext ctx)
        {
            yield return new ProjectItemDefinition("ClCompile", $"{Constants.Condition.PlatformWin32OrX64} and {Constants.Condition.PlatformToolsetUseCl}",
                // Debug ビルドの場合は EditAndContinue とする
                // ただし VS2013 では x64 プラットフォームの EditAndContinue はサポートされていない (D9038 の警告が出る) ので ProgramDatabase を使用する
                new ProjectMetadata("DebugInformationFormat", "EditAndContinue",
                    $"('$(_NintendoSdkDebugInfoGenerationEnabled)'=='true') and {Constants.Condition.NintendoSdkBuildTypeDebug} and ('$(Platform)'!='x64' or '$(PlatformToolset)'!='v120')"),
                new ProjectMetadata("DebugInformationFormat", "ProgramDatabase",
                    $"('$(_NintendoSdkDebugInfoGenerationEnabled)'=='true') and {Constants.Condition.NintendoSdkBuildTypeDebug} and ('$(Platform)'=='x64' and '$(PlatformToolset)'=='v120')"),
                new ProjectMetadata("DebugInformationFormat", "ProgramDatabase",
                    $"('$(_NintendoSdkDebugInfoGenerationEnabled)'=='true') and {Constants.Condition.NintendoSdkBuildTypeDevelopOrRelease}"),
                // _NintendoSdkDebugInfoGenerationEnabled が true でない場合はデバッグ情報を生成しない（リリースするライブラリでは PDB ファイルへの参照を埋め込まないようにするため）
                new ProjectMetadata("DebugInformationFormat", string.Empty,
                    "'$(_NintendoSdkDebugInfoGenerationEnabled)'!='true'"));

            yield return new ProjectItemDefinition("ClCompile", $"{Constants.Condition.PlatformWin32OrX64} and {Constants.Condition.PlatformToolsetUseClang}",
                new ProjectMetadata("DebugInformationFormat", "FullDebug",
                    $"('$(_NintendoSdkDebugInfoGenerationEnabled)'=='true')"),
                new ProjectMetadata("DebugInformationFormat", "None",
                    $"('$(_NintendoSdkDebugInfoGenerationEnabled)'!='true')"));
        }
    }
}
