﻿using Nintendo.SigloBuild.Settings;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MakeBuildRules
{
    internal class BuildRuleMaker
    {
        private static readonly string ToolChainsNarlPath = @"Common\Build\Nact\Environment\TargetToolChainsInfo.autogen.narl";
        private static readonly Encoding Utf8BomEncoding = new UTF8Encoding(true);
        private readonly string _sigloRoot;

        private BuildRuleMaker(string sigloRoot)
        {
            this._sigloRoot = sigloRoot;
        }

        public static void Execute(string sigloRoot)
        {
            new BuildRuleMaker(sigloRoot).Execute();
        }

        private void Execute()
        {
            MakeToolChainsNarl();
        }

        private void MakeToolChainsNarl()
        {
            var settings = BuildSettings.Create();
            var path = Path.Combine(_sigloRoot, ToolChainsNarlPath);

            using (var sw = new StreamWriter(path, false, Utf8BomEncoding))
            {
                WriteAutogenNotice(sw);
                sw.WriteLine("@private targetToolChains = Constants");
                sw.WriteLine("{");
                WriteToolChain(sw, settings.ToolChains.Rynda);
                WriteToolChain(sw, settings.ToolChains.SigloGcc);
                WriteToolChain(sw, settings.ToolChains.SigloMsys);
                WriteToolChain(sw, settings.ToolChains.SigloDtc);
                sw.WriteLine("};");
            }
        }

        private static void WriteToolChain(StreamWriter sw, ToolChain toolChain)
        {
            sw.WriteLine($"    @public {toolChain.Id} = Constants");
            sw.WriteLine("    {");
            sw.WriteLine($"        @public Version = \"{toolChain.Version}\";");
            sw.WriteLine("    };");
        }

        private static void WriteAutogenNotice(StreamWriter sw)
        {
            sw.WriteLine("// DO NOT EDIT; this file was generated by `nact outputs=buildsystem`.");
            sw.WriteLine();
        }
    }
}
