﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;

namespace MakeBuildConfigHeaders
{
    class NactObjectXmlReader
    {
        public NactObjectXmlReader()
        {

        }

        public object Read(string path)
        {
            var doc = XDocument.Load(path);
            if (doc.Root.Name != "NactObject" || doc.Root.Elements().Count() != 1)
            {
                throw new ArgumentException(string.Format("{0} : Not an XML file created from a nact object.", path), nameof(path));
            }

            return ConvertOne(doc.Root.Elements().Single());
        }

        private object ConvertOne(XElement e)
        {
            switch (e.Name.LocalName)
            {
                case "ValueString":
                case "FilePath":
                case "DirectoryContents":
                    return e.Value;
                case "ValueNumber":
                    return double.Parse(e.Value);
                case "ValueBool":
                    return bool.Parse(e.Value);
                case "ValueUndefined":
                    return null;
                case "ValueList":
                    return e.Elements().Select(x => ConvertOne(x)).ToList();
                case "ValueMap":
                    return e.Elements().ToDictionary(x => x.Attribute("Key").Value, x => ConvertOne(x));
                default:
                    throw new ArgumentException();
            }
        }
    }
}
