﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>
#include <string>

#include <git2.h>

#include "HandleHolder.h"

using namespace System;

namespace Libgit2 {

    struct TreeEntryNative
    {
        unsigned long long size;
        std::string filename;
    };

    public ref class TreeEntry
    {
    public:
        System::String^ FilePath;
        long FileSize;
    };

    class TreeWalker
    {
    public:
        static int TreeWalkFunction(const char* root, const git_tree_entry* entry, void* payload);

        TreeWalker(git_repository* repository, std::vector<TreeEntryNative>* entries);

    private:
        git_repository* m_pRepository;
        std::vector<TreeEntryNative>* m_pTreeEntries;
    };
}
