﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>
#include <string>
#include <algorithm>
#include <msclr/marshal.h>
#include <msclr/marshal_cppstd.h>

#include <git2.h>

#include "HandleHolder.h"
#include "TreeWalker.h"

using namespace System;
using namespace System::Collections::Generic;
using namespace System::Runtime::InteropServices;
using namespace msclr::interop;

namespace Libgit2 {

    public ref class Repository
    {
    public:
        Repository(String^ workingDirectory);
        ~Repository();

        void Init();
        void Open();

        String^ GetGitDirectory();
        String^ GetRootDirectory();
        Boolean IsInsideRepository();

        String^ GetConfig(String^ name);
        void SetConfig(String^ name, String^ value);

        void Add(String^ filepath);
        String^ ShowHead(String^ filepath);
        void Checkout(List<String^>^ filelist);
        void Expand(List<String^>^ filelist, String^ cacheDirectoryPath);
        IEnumerable<TreeEntry^>^ GetHeadTree();
        void SetAssumeUnchanged(List<String^>^ filelist, bool assumeUnchanged);

    private:
        String^ m_WorkingDirectory;
        RepositoryHolder *m_pRepository;
    };
}
