﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using GitExternalStorage.Configs;
using GitExternalStorage.Transports;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace GitExternalStorage
{
    public static class Utils
    {
        private static readonly string[] SizeUnits = { "B", "KB", "MB" };

        /// <summary>
        /// 数値を単位 (B, KB, MB) 付き文字列に変換します。
        /// </summary>
        /// <param name="value">変換対象の数値</param>
        /// <returns>単位付き数値文字列</returns>
        public static string ValueToStringWithSizeUnit(long value)
        {
            int mag = value <= 0 ? 0 : (int)Math.Log(value, 1024);
            if (mag >= SizeUnits.Length)
            {
                mag = SizeUnits.Length - 1;
            }
            var adjustedSize = value / (1L << (mag * 10));

            return string.Format("{0}{1}", adjustedSize, SizeUnits[mag]);
        }
    }
}
