﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.Text;
using System.Threading.Tasks;

namespace GitExternalStorage.Transports
{
    /// <summary>
    /// 外部ストレージ上にファイルが見つからない場合に発生する例外です。
    /// </summary>
    public class TransportFileNotFoundException : Exception
    {
        public TransportFileNotFoundException()
            : base()
        {
        }

        public TransportFileNotFoundException(string message)
            : base(message)
        {
        }

        protected TransportFileNotFoundException(SerializationInfo info, StreamingContext context)
            : base(info, context)
        {
        }

        public TransportFileNotFoundException(string message, Exception innerException)
            : base(message, innerException)
        {
        }
    }
}
