﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace GitExternalStorage.Core
{
    /// <summary>
    /// 各キャッシュの情報を表します。
    /// </summary>
    public class LocalCacheEntry
    {
        /// <summary>
        /// ハッシュ値
        /// </summary>
        public string Sha { get; set; }
    }

    /// <summary>
    /// 外部ストレージとキャッシュの同期状態を表します。
    /// </summary>
    public class LocalCacheInfo
    {
        /// <summary>
        /// 外部ストレージに同期されておらず、ローカルにのみ存在するキャッシュ
        /// </summary>
        public List<LocalCacheEntry> Unpushed { get; set; }
        /// <summary>
        /// 外部ストレージに同期済みのキャッシュ
        /// </summary>
        public List<LocalCacheEntry> Pushed { get; set; }
    }
}
