﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace GitExternalStorage.Consoles
{
    /// <summary>
    /// 標準ストリームを入出力コンソールとして表現するクラスです。
    /// </summary>
    public class StandardStreamCommandConsole : CommandConsoleBase
    {
        protected override TextReader OpenInputReader()
        {
            return Console.In;
        }

        protected override TextWriter OpenOutputWriter()
        {
            return Console.Out;
        }

        protected override TextWriter OpenErrorWriter()
        {
            return Console.Error;
        }

        public override Stream OpenInputStream()
        {
            return Console.OpenStandardInput();
        }

        public override Stream OpenOutputStream()
        {
            return Console.OpenStandardOutput();
        }

        public override Stream OpenErrorStream()
        {
            return Console.OpenStandardError();
        }
    }
}
