﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using GitExternalStorage.Consoles;
using GitExternalStorage.Core;
using GitExternalStorage.Transports;

namespace GitExternalStorage.Commands
{
    /// <summary>
    /// git の update-index --no-assume-unchanged 相当の操作を行うコマンドです。
    /// </summary>
    public class NoAssumeUnchangedCommand : CommandBase
    {
        public NoAssumeUnchangedCommand()
            : base()
        {
        }

        public NoAssumeUnchangedCommand(CommandConsoleBase console)
            : base(console)
        {
        }

        public override void Run()
        {
            this.NoAssumeUnchanged();
        }

        /// <summary>
        /// 管理対象ファイルをすべて --no-assume-unchanged にします。
        /// </summary>
        private void NoAssumeUnchanged()
        {
            CommandConsole.WriteLineToOut("Set files to 'no-assume-unchanged'.");
            var referenceInfo = Reference.FindReferences(Environments.GitRepository);

            if (referenceInfo.All.Count() > 0)
            {
                Environments.GitRepositoryLibgit2.SetAssumeUnchanged(referenceInfo.All.Select(x => x.FilePath).ToList(), false);
            }

            CommandConsole.WriteLineToOut("Complete!");
        }
    }
}
