﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using GitExternalStorage.Consoles;

namespace GitExternalStorage.Commands
{
    /// <summary>
    /// コマンドの基底クラスです。
    /// </summary>
    public abstract class CommandBase
    {
        public CommandConsoleBase CommandConsole { get; private set; }

        public CommandBase()
            : this(new StandardStreamCommandConsole())
        {
        }

        public CommandBase(CommandConsoleBase console)
        {
            this.CommandConsole = console;
        }

        /// <summary>
        /// コマンドに対応した処理を実行します。
        /// </summary>
        public abstract void Run();
    }
}
