﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using GitExternalStorage.Consoles;
using GitExternalStorage.Core;

namespace GitExternalStorage.Commands
{
    /// <summary>
    /// キャッシュを削除するコマンドです。
    /// </summary>
    public class ClearCommand : CommandBase
    {
        public ClearCommand()
            : base()
        {
        }

        public ClearCommand(CommandConsoleBase console)
            : base(console)
        {
        }

        public override void Run()
        {
            this.ClearLocalCache();
        }

        private void ClearLocalCache()
        {
            var cacheDirectory = Environments.GetCacheDirectoryPath();
            var cacheInfo = LocalCache.FindLocalCaches(cacheDirectory, Environments.Transport);
            foreach (var e in cacheInfo.Pushed)
            {
                CommandConsole.WriteLineToOut("Removing {0}", e.Sha);
                File.Delete(Path.Combine(cacheDirectory, e.Sha));
            }
        }
    }
}
