﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using GitExternalRepositoryManager.Commands;
using GitExternalRepositoryManager.Exceptions;
using Nintendo.Foundation.IO;

namespace GitExternalRepositoryManager
{
    public class Program
    {
        private class Parameters
        {
            [CommandLineSubCommand("init", Description = "Initialize external repositories.")]
            public InitCommand.Parameters InitCommandParameters { get; set; }

            public object GetValidCommandParameters()
            {
                return (object)this.InitCommandParameters;
            }
        }

        private static void Main(string[] args)
        {
#if DEBUG
            Execute(args);
#else
            try
            {
                Execute(args);
            }
            catch (GitExternalRepositoryManagerException e)
            {
                // アプリケーションでハンドルした例外です。
                StringBuilder detailBuilder = new StringBuilder();
                for (Exception exception = e; exception != null; exception = exception.InnerException)
                {
                    if (exception.Data.Contains("Detail"))
                    {
                        detailBuilder.Append(exception.Data["Detail"]);
                    }
                }
                Console.Error.WriteLine("Error : {0} {1}", e.Message, detailBuilder.ToString());

                Environment.Exit(1);
            }
            catch (CommandLineArgException)
            {
                // CommandLineParser がエラー出力するので、ここでは何も出力しない
                Environment.Exit(1);
            }
            catch (Exception e)
            {
                // コード中で未ハンドルのエラーをここで捕まえます。
                StringBuilder detailBuilder = new StringBuilder();
                for (Exception exception = e; exception != null; exception = exception.InnerException)
                {
                    if (exception.Data.Contains("Detail"))
                    {
                        detailBuilder.Append(exception.Data["Detail"]);
                    }
                }

                Console.Error.WriteLine("Internal error : {0} {1}", e.Message, detailBuilder.ToString());
                Console.Error.WriteLine(string.Empty);
                Console.Error.WriteLine("== Exception ==");
                Console.Error.WriteLine(string.Empty);
                Console.Error.WriteLine(e.ToString());

                Environment.Exit(1);
            }
#endif
        }

        private static void Execute(string[] args)
        {
            var settings = new CommandLineParserSettings()
            {
                ApplicationName = "git-exrepo-m",
                ApplicationDescription = "Manage git-exrepo.",
            };

            Parameters parameters;

            try
            {
                if (!new CommandLineParser(settings).ParseArgs<Parameters>(args, out parameters))
                {
                    return;
                }
            }
            catch (Exception exception)
            {
                throw new CommandLineArgException(exception);
            }

            var commandParameters = parameters.GetValidCommandParameters();

            if (commandParameters is InitCommand.Parameters)
            {
                // init コマンド
                new InitCommand().Execute((InitCommand.Parameters)commandParameters);
            }
            else
            {
                throw new GitExternalRepositoryManagerException("Failed to parse a command.");
            }
        }
    }
}
