﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using GitExternalRepository.Configs;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace GitExternalRepository.Exstorage
{
    public class ExstorageAliasListEntry
    {
        [EntryMember("exstorage", isRequired: false)]
        public string ExstorageAlias { get; set; }

        public override bool Equals(System.Object obj)
        {
            if (obj == null)
            {
                return false;
            }

            return this.Equals(obj as ExstorageAliasListEntry);
        }

        public bool Equals(ExstorageAliasListEntry obj)
        {
            if ((object)obj == null)
            {
                return false;
            }

            return this.ExstorageAlias == obj.ExstorageAlias;
        }

        public override int GetHashCode()
        {
            return this.ExstorageAlias.GetHashCode();
        }
    }
}
