﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.Text;
using System.Threading.Tasks;

namespace GitExternalRepository.Commands
{
    /// <summary>
    /// コマンドの属性が未定義のときに発生する例外です。
    /// </summary>
    public class CommandDefinitionAttributeNotDefinedException : Exception
    {
        public CommandDefinitionAttributeNotDefinedException()
            : base()
        {
        }

        public CommandDefinitionAttributeNotDefinedException(string message)
            : base(message)
        {
        }

        protected CommandDefinitionAttributeNotDefinedException(SerializationInfo info, StreamingContext context)
            : base(info, context)
        {
        }

        public CommandDefinitionAttributeNotDefinedException(string message, Exception innerException)
            : base(message, innerException)
        {
        }
    }
}
