﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using GitExternalRepository.Repository.Git;

namespace GitExternalRepository.Configs
{
    /// <summary>
    /// .gitmodules を扱うクラスです。
    /// </summary>
    public class SubmoduleRepositoryListGitConfig : EntryListGitConfig<SubmoduleRepositoryListEntry>
    {
        /// <summary>
        /// 指定のファイルをサブモジュールのリポジトリリストとして扱います。
        /// </summary>
        /// <param name="filepath">リポジトリリストへのパス</param>
        public SubmoduleRepositoryListGitConfig(string filepath)
            : base(filepath, "submodule", SubSectionType.Required)
        {
        }
    }
}
