﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;

namespace GitExternalRepository.Configs
{
    /// <summary>
    /// プロパティと属性情報の組
    /// </summary>
    public class EntryPropertyAttributeInfo<TAttribute>
    {
        public PropertyInfo PropertyInfo { get; set; }
        public TAttribute Attribute { get; set; }
    }

    /// <summary>
    /// セクション情報を収めるプロパティに付与する属性です。
    /// </summary>
    [AttributeUsage(AttributeTargets.Property, Inherited = false, AllowMultiple = false)]
    public sealed class EntrySectionAttribute : Attribute
    {
    }

    /// <summary>
    /// サブセクション情報を収めるプロパティに付与する属性です。
    /// </summary>
    [AttributeUsage(AttributeTargets.Property, Inherited = false, AllowMultiple = false)]
    public sealed class EntrySubSectionAttribute : Attribute
    {
    }

    /// <summary>
    /// リポジトリリストエントリの各メンバに付与すべき属性です。
    /// </summary>
    [AttributeUsage(AttributeTargets.Property, Inherited = false, AllowMultiple = false)]
    public sealed class EntryMemberAttribute : Attribute
    {
        /// <summary>
        /// エントリ名
        /// </summary>
        public string EntryName { get; set; }

        /// <summary>
        /// 必須のエントリかどうか
        /// </summary>
        public bool IsRequired { get; set; }

        /// <summary>
        /// デフォルト値（オプションエントリでない場合のみ有効）
        /// </summary>
        public object DefaultValue { get; set; }

        public EntryMemberAttribute(string entryName, bool isRequired = true, object defaultValue = null)
        {
            EntryName = entryName;
            IsRequired = isRequired;
            DefaultValue = defaultValue;
        }
    }
}
