﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using GitExternalRepository.Consoles;

namespace GitExternalRepository.Commands
{
    /// <summary>
    /// コマンドの基底クラスです。
    /// </summary>
    public abstract class CommandBase
    {
        public ConsoleBase CommandConsole { get; private set; }

        public CommandBase()
            : this(new StandardStreamConsole())
        {
        }

        public CommandBase(ConsoleBase console)
        {
            this.CommandConsole = console;
        }

        /// <summary>
        /// 自信のクラスに定義された CommandDefinitionAttribute 属性を取得します。
        /// </summary>
        /// <returns></returns>
        public CommandDefinitionAttribute GetCommandDefinitionAttribute()
        {
            return (CommandDefinitionAttribute)Attribute.GetCustomAttribute(this.GetType(), typeof(CommandDefinitionAttribute));
        }

        /// <summary>
        /// コマンドに対応した処理を実行します。
        /// </summary>
        /// <param name="parameters">コマンドのパラメータを指定します。</param>
        /// <returns>
        /// 処理に成功したら true、ヘルプオプションなどにより処理をスキップしたら false を返します。
        /// エラーが発生した場合は、例外が投げられます。
        /// </returns>
        public abstract bool Execute(object parameters);
    }
}
