﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/util/util_Vector.h>

namespace nn { namespace util {

const Vector2fType Vector2f::ConstantZero  = NN_UTIL_VECTOR_2F_INITIALIZER(0.f, 0.f);
const Vector2fType Vector2f::ConstantOne   = NN_UTIL_VECTOR_2F_INITIALIZER(1.f, 1.f);
const Vector2fType Vector2f::ConstantUnitX = NN_UTIL_VECTOR_2F_INITIALIZER(1.f, 0.f);
const Vector2fType Vector2f::ConstantUnitY = NN_UTIL_VECTOR_2F_INITIALIZER(0.f, 1.f);

const Vector3fType Vector3f::ConstantZero = NN_UTIL_VECTOR_3F_INITIALIZER(0.f, 0.f, 0.f);
const Vector3fType Vector3f::ConstantOne = NN_UTIL_VECTOR_3F_INITIALIZER(1.f, 1.f, 1.f);
const Vector3fType Vector3f::ConstantUnitX = NN_UTIL_VECTOR_3F_INITIALIZER(1.f, 0.f, 0.f);
const Vector3fType Vector3f::ConstantUnitY = NN_UTIL_VECTOR_3F_INITIALIZER(0.f, 1.f, 0.f);
const Vector3fType Vector3f::ConstantUnitZ = NN_UTIL_VECTOR_3F_INITIALIZER(0.f, 0.f, 1.f);

const Vector4fType Vector4f::ConstantZero  = NN_UTIL_VECTOR_4F_INITIALIZER(0.f, 0.f, 0.f, 0.f);
const Vector4fType Vector4f::ConstantOne   = NN_UTIL_VECTOR_4F_INITIALIZER(1.f, 1.f, 1.f, 1.f);
const Vector4fType Vector4f::ConstantUnitX = NN_UTIL_VECTOR_4F_INITIALIZER(1.f, 0.f, 0.f, 0.f);
const Vector4fType Vector4f::ConstantUnitY = NN_UTIL_VECTOR_4F_INITIALIZER(0.f, 1.f, 0.f, 0.f);
const Vector4fType Vector4f::ConstantUnitZ = NN_UTIL_VECTOR_4F_INITIALIZER(0.f, 0.f, 1.f, 0.f);
const Vector4fType Vector4f::ConstantUnitW = NN_UTIL_VECTOR_4F_INITIALIZER(0.f, 0.f, 0.f, 1.f);

}}
