﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/util/util_ResDic.h>

namespace nn { namespace util {

NN_DEFINE_STATIC_CONSTANT( const int ResDic::Npos );

bool ResDic::Build() NN_NOEXCEPT
{
    ResDicData& ref = ToData();
    Entry* pEntries = ref.entries;

    for ( int idxEntry = 0, numEntry = ref.count + 1; idxEntry < numEntry; ++idxEntry )
    {
        Entry* pEntry = &pEntries[ idxEntry ];
        pEntry->children[ 0 ] = pEntry->children[ 1 ] = static_cast< uint16_t >( idxEntry );
        pEntry->refBit = Npos;
    }

    for ( int idxEntry = 1, numEntry = ref.count + 1; idxEntry < numEntry; ++idxEntry )
    {
        Entry* pEntry = &pEntries[ idxEntry ];
        const string_view key = *pEntry->pKey.Get();
        const Entry* pFound = FindImpl( key );
        pEntry->refBit = FindRefBit( key, *pFound->pKey.Get() );
        if ( pEntry->refBit == Npos )
        {
            return false; // キーが重複した場合はエラーとして扱います。
        }

        Entry* pParent = &pEntries[ 0 ];
        Entry* pChild = &pEntries[ pParent->children[ 0 ] ];

        while ( Older( pParent, pChild ) && Older( pChild, pEntry ) )
        {
            pParent = pChild;
            pChild = GetChild( pParent, key );
        }
        // この時点で pParent と pChild の間にノードを挿入することが確定しています。

        SetChild( pParent, pEntry );
        SetChild( pEntry, pChild );
    }

    return true;
}

int ResDic::FindRefBit( const string_view& lhs, const string_view& rhs ) NN_NOEXCEPT
{
    // 戻った先のノードエントリと違うビットを探します。
    // refBit ビット目で判断することにします。
    int endBit = static_cast< int >( CHAR_BIT * std::max NN_PREVENT_MACRO_FUNC ( lhs.length(), rhs.length() ) );
    for ( int refBit = 0; refBit < endBit; ++refBit )
    {
        if ( ExtractRefBit( lhs, refBit ) != ExtractRefBit( rhs, refBit ) )
        {
            return refBit;
        }
    }
    return Npos; // 名前が重複している場合は失敗です。
}

}} // namespace nn/util
