﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/util/detail/util_ConstantImpl.h>
#include <limits>

namespace nn { namespace util { namespace detail {

const float FloatPi             = 3.141592653589793f;       //!< π
const float Float2Pi            = 6.283185307179586f;       //!< 2π
const float FloatPiDivided2     = 1.570796326794896f;       //!< 1/2π
const float Float3PiDivided2    = 4.712388980384689f;       //!< 3/2π
const float Float1Divided2Pi    = 0.15915494309189535f;     //!< 1/(2π)

const float FloatDegree180 = 180.f;     //!< 180度

const float FloatQuaternionEpsilon = 0.00001f;

const float FloatUlp = ::std::numeric_limits<float>::epsilon();            //!< 1.f + x != 1.f を満たす最小の正の値

const float FloatSqrt0Point5    = 0.70710678118654752f;     //!< sqrt(0.5)

const AngleIndex AngleIndexHalfRound            = 0x80000000;   //!< インデックス表現での 1/2 周
const AngleIndex AngleIndexQuarterRound         = 0x40000000;   //!< インデックス表現での 1/4 周
const AngleIndex AngleIndexThreeQuarterRound    = 0xc0000000;   //!< インデックス表現での 3/4 周

}}}
