﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/util/detail/util_ArithmeticImpl.h>

namespace nn { namespace util { namespace detail {

//
// 多項式近似による三角関数の内部実装に用います。
//

const float SinCoefficients[5] =
{
    2.47284308585449252859689295291900634765625e-8f,
    2.75829779639025218784809112548828125e-6f,
    1.98422887478955090045928955078125e-4f,
    8.33334587514400482177734375e-3f,
    0.16666667163372039794921875f
};

const float CosCoefficients[5] =
{
    2.62119527860704693011939525604248046875e-7f,
    2.4770297386567108333110809326171875e-5f,
    1.388858654536306858062744140625e-3f,
    4.16666567325592041015625e-2f,
    0.5f
};

const float AtanCoefficients[8] =
{
    2.603463828563690185546875e-3f,
    1.5111059881746768951416015625e-2f,
    4.11989279091358184814453125e-2f,
    7.385678589344024658203125e-2f,
    0.105906970798969268798828125f,
    0.1419301927089691162109375f,
    0.19991767406463623046875f,
    0.333330810070037841796875f,
};

//
// テーブルによる三角関数の内部実装に用います。
//

const SinCosSample SinCosSampleTable[256] =
{
    { 1.0000000e+000f, 0.0000000e+000f, -2.6354215e-004f, 2.4542153e-002f },
    { 9.9973646e-001f, 2.4542153e-002f, -9.0339650e-004f, 2.4527369e-002f },
    { 9.9883306e-001f, 4.9069522e-002f, -1.5050562e-003f, 2.4497812e-002f },
    { 9.9732801e-001f, 7.3567333e-002f, -2.1058093e-003f, 2.4453497e-002f },
    { 9.9522220e-001f, 9.8020831e-002f, -2.7052939e-003f, 2.4394453e-002f },
    { 9.9251690e-001f, 1.2241528e-001f, -3.3031490e-003f, 2.4320715e-002f },
    { 9.8921375e-001f, 1.4673600e-001f, -3.8990144e-003f, 2.4232327e-002f },
    { 9.8531474e-001f, 1.7096833e-001f, -4.4925311e-003f, 2.4129342e-002f },
    { 9.8082221e-001f, 1.9509767e-001f, -5.0833417e-003f, 2.4011822e-002f },
    { 9.7573887e-001f, 2.1910949e-001f, -5.6710904e-003f, 2.3879839e-002f },
    { 9.7006778e-001f, 2.4298933e-001f, -6.2554229e-003f, 2.3733471e-002f },
    { 9.6381235e-001f, 2.6672280e-001f, -6.8359874e-003f, 2.3572807e-002f },
    { 9.5697637e-001f, 2.9029561e-001f, -7.4124342e-003f, 2.3397944e-002f },
    { 9.4956393e-001f, 3.1369355e-001f, -7.9844160e-003f, 2.3208987e-002f },
    { 9.4157951e-001f, 3.3690254e-001f, -8.5515883e-003f, 2.3006049e-002f },
    { 9.3302793e-001f, 3.5990859e-001f, -9.1136094e-003f, 2.2789254e-002f },
    { 9.2391432e-001f, 3.8269784e-001f, -9.6701409e-003f, 2.2558731e-002f },
    { 9.1424418e-001f, 4.0525657e-001f, -1.0220847e-002f, 2.2314620e-002f },
    { 9.0402333e-001f, 4.2757119e-001f, -1.0765397e-002f, 2.2057067e-002f },
    { 8.9325793e-001f, 4.4962826e-001f, -1.1303462e-002f, 2.1786227e-002f },
    { 8.8195447e-001f, 4.7141449e-001f, -1.1834719e-002f, 2.1502265e-002f },
    { 8.7011975e-001f, 4.9291675e-001f, -1.2358846e-002f, 2.1205350e-002f },
    { 8.5776090e-001f, 5.1412210e-001f, -1.2875530e-002f, 2.0895662e-002f },
    { 8.4488537e-001f, 5.3501776e-001f, -1.3384457e-002f, 2.0573388e-002f },
    { 8.3150092e-001f, 5.5559115e-001f, -1.3885322e-002f, 2.0238720e-002f },
    { 8.1761560e-001f, 5.7582987e-001f, -1.4377823e-002f, 1.9891862e-002f },
    { 8.0323777e-001f, 5.9572173e-001f, -1.4861663e-002f, 1.9533021e-002f },
    { 7.8837611e-001f, 6.1525475e-001f, -1.5336552e-002f, 1.9162415e-002f },
    { 7.7303956e-001f, 6.3441717e-001f, -1.5802202e-002f, 1.8780266e-002f },
    { 7.5723736e-001f, 6.5319744e-001f, -1.6258333e-002f, 1.8386804e-002f },
    { 7.4097902e-001f, 6.7158424e-001f, -1.6704671e-002f, 1.7982267e-002f },
    { 7.2427435e-001f, 6.8956651e-001f, -1.7140947e-002f, 1.7566898e-002f },
    { 7.0713340e-001f, 7.0713340e-001f, -1.7566898e-002f, 1.7140947e-002f },
    { 6.8956651e-001f, 7.2427435e-001f, -1.7982267e-002f, 1.6704671e-002f },
    { 6.7158424e-001f, 7.4097902e-001f, -1.8386804e-002f, 1.6258333e-002f },
    { 6.5319744e-001f, 7.5723736e-001f, -1.8780266e-002f, 1.5802202e-002f },
    { 6.3441717e-001f, 7.7303956e-001f, -1.9162415e-002f, 1.5336552e-002f },
    { 6.1525475e-001f, 7.8837611e-001f, -1.9533021e-002f, 1.4861663e-002f },
    { 5.9572173e-001f, 8.0323777e-001f, -1.9891862e-002f, 1.4377823e-002f },
    { 5.7582987e-001f, 8.1761560e-001f, -2.0238720e-002f, 1.3885322e-002f },
    { 5.5559115e-001f, 8.3150092e-001f, -2.0573388e-002f, 1.3384457e-002f },
    { 5.3501776e-001f, 8.4488537e-001f, -2.0895662e-002f, 1.2875530e-002f },
    { 5.1412210e-001f, 8.5776090e-001f, -2.1205350e-002f, 1.2358846e-002f },
    { 4.9291675e-001f, 8.7011975e-001f, -2.1502265e-002f, 1.1834719e-002f },
    { 4.7141449e-001f, 8.8195447e-001f, -2.1786227e-002f, 1.1303462e-002f },
    { 4.4962826e-001f, 8.9325793e-001f, -2.2057067e-002f, 1.0765397e-002f },
    { 4.2757119e-001f, 9.0402333e-001f, -2.2314620e-002f, 1.0220847e-002f },
    { 4.0525657e-001f, 9.1424418e-001f, -2.2558731e-002f, 9.6701409e-003f },
    { 3.8269784e-001f, 9.2391432e-001f, -2.2789254e-002f, 9.1136094e-003f },
    { 3.5990859e-001f, 9.3302793e-001f, -2.3006049e-002f, 8.5515883e-003f },
    { 3.3690254e-001f, 9.4157951e-001f, -2.3208987e-002f, 7.9844160e-003f },
    { 3.1369355e-001f, 9.4956393e-001f, -2.3397944e-002f, 7.4124342e-003f },
    { 2.9029561e-001f, 9.5697637e-001f, -2.3572807e-002f, 6.8359874e-003f },
    { 2.6672280e-001f, 9.6381235e-001f, -2.3733471e-002f, 6.2554229e-003f },
    { 2.4298933e-001f, 9.7006778e-001f, -2.3879839e-002f, 5.6710904e-003f },
    { 2.1910949e-001f, 9.7573887e-001f, -2.4011822e-002f, 5.0833417e-003f },
    { 1.9509767e-001f, 9.8082221e-001f, -2.4129342e-002f, 4.4925311e-003f },
    { 1.7096833e-001f, 9.8531474e-001f, -2.4232327e-002f, 3.8990144e-003f },
    { 1.4673600e-001f, 9.8921375e-001f, -2.4320715e-002f, 3.3031490e-003f },
    { 1.2241528e-001f, 9.9251690e-001f, -2.4394453e-002f, 2.7052939e-003f },
    { 9.8020831e-002f, 9.9522220e-001f, -2.4453497e-002f, 2.1058093e-003f },
    { 7.3567333e-002f, 9.9732801e-001f, -2.4497812e-002f, 1.5050562e-003f },
    { 4.9069522e-002f, 9.9883306e-001f, -2.4527369e-002f, 9.0339650e-004f },
    { 2.4542153e-002f, 9.9973646e-001f, -2.4542153e-002f, 2.6354215e-004f },
    { 0.0000000e+000f, 1.0000000e+000f, -2.4542153e-002f, -2.6354215e-004f },
    { -2.4542153e-002f, 9.9973646e-001f, -2.4527369e-002f, -9.0339650e-004f },
    { -4.9069522e-002f, 9.9883306e-001f, -2.4497812e-002f, -1.5050562e-003f },
    { -7.3567333e-002f, 9.9732801e-001f, -2.4453497e-002f, -2.1058093e-003f },
    { -9.8020831e-002f, 9.9522220e-001f, -2.4394453e-002f, -2.7052939e-003f },
    { -1.2241528e-001f, 9.9251690e-001f, -2.4320715e-002f, -3.3031490e-003f },
    { -1.4673600e-001f, 9.8921375e-001f, -2.4232327e-002f, -3.8990144e-003f },
    { -1.7096833e-001f, 9.8531474e-001f, -2.4129342e-002f, -4.4925311e-003f },
    { -1.9509767e-001f, 9.8082221e-001f, -2.4011822e-002f, -5.0833417e-003f },
    { -2.1910949e-001f, 9.7573887e-001f, -2.3879839e-002f, -5.6710904e-003f },
    { -2.4298933e-001f, 9.7006778e-001f, -2.3733471e-002f, -6.2554229e-003f },
    { -2.6672280e-001f, 9.6381235e-001f, -2.3572807e-002f, -6.8359874e-003f },
    { -2.9029561e-001f, 9.5697637e-001f, -2.3397944e-002f, -7.4124342e-003f },
    { -3.1369355e-001f, 9.4956393e-001f, -2.3208987e-002f, -7.9844160e-003f },
    { -3.3690254e-001f, 9.4157951e-001f, -2.3006049e-002f, -8.5515883e-003f },
    { -3.5990859e-001f, 9.3302793e-001f, -2.2789254e-002f, -9.1136094e-003f },
    { -3.8269784e-001f, 9.2391432e-001f, -2.2558731e-002f, -9.6701409e-003f },
    { -4.0525657e-001f, 9.1424418e-001f, -2.2314620e-002f, -1.0220847e-002f },
    { -4.2757119e-001f, 9.0402333e-001f, -2.2057067e-002f, -1.0765397e-002f },
    { -4.4962826e-001f, 8.9325793e-001f, -2.1786227e-002f, -1.1303462e-002f },
    { -4.7141449e-001f, 8.8195447e-001f, -2.1502265e-002f, -1.1834719e-002f },
    { -4.9291675e-001f, 8.7011975e-001f, -2.1205350e-002f, -1.2358846e-002f },
    { -5.1412210e-001f, 8.5776090e-001f, -2.0895662e-002f, -1.2875530e-002f },
    { -5.3501776e-001f, 8.4488537e-001f, -2.0573388e-002f, -1.3384457e-002f },
    { -5.5559115e-001f, 8.3150092e-001f, -2.0238720e-002f, -1.3885322e-002f },
    { -5.7582987e-001f, 8.1761560e-001f, -1.9891862e-002f, -1.4377823e-002f },
    { -5.9572173e-001f, 8.0323777e-001f, -1.9533021e-002f, -1.4861663e-002f },
    { -6.1525475e-001f, 7.8837611e-001f, -1.9162415e-002f, -1.5336552e-002f },
    { -6.3441717e-001f, 7.7303956e-001f, -1.8780266e-002f, -1.5802202e-002f },
    { -6.5319744e-001f, 7.5723736e-001f, -1.8386804e-002f, -1.6258333e-002f },
    { -6.7158424e-001f, 7.4097902e-001f, -1.7982267e-002f, -1.6704671e-002f },
    { -6.8956651e-001f, 7.2427435e-001f, -1.7566898e-002f, -1.7140947e-002f },
    { -7.0713340e-001f, 7.0713340e-001f, -1.7140947e-002f, -1.7566898e-002f },
    { -7.2427435e-001f, 6.8956651e-001f, -1.6704671e-002f, -1.7982267e-002f },
    { -7.4097902e-001f, 6.7158424e-001f, -1.6258333e-002f, -1.8386804e-002f },
    { -7.5723736e-001f, 6.5319744e-001f, -1.5802202e-002f, -1.8780266e-002f },
    { -7.7303956e-001f, 6.3441717e-001f, -1.5336552e-002f, -1.9162415e-002f },
    { -7.8837611e-001f, 6.1525475e-001f, -1.4861663e-002f, -1.9533021e-002f },
    { -8.0323777e-001f, 5.9572173e-001f, -1.4377823e-002f, -1.9891862e-002f },
    { -8.1761560e-001f, 5.7582987e-001f, -1.3885322e-002f, -2.0238720e-002f },
    { -8.3150092e-001f, 5.5559115e-001f, -1.3384457e-002f, -2.0573388e-002f },
    { -8.4488537e-001f, 5.3501776e-001f, -1.2875530e-002f, -2.0895662e-002f },
    { -8.5776090e-001f, 5.1412210e-001f, -1.2358846e-002f, -2.1205350e-002f },
    { -8.7011975e-001f, 4.9291675e-001f, -1.1834719e-002f, -2.1502265e-002f },
    { -8.8195447e-001f, 4.7141449e-001f, -1.1303462e-002f, -2.1786227e-002f },
    { -8.9325793e-001f, 4.4962826e-001f, -1.0765397e-002f, -2.2057067e-002f },
    { -9.0402333e-001f, 4.2757119e-001f, -1.0220847e-002f, -2.2314620e-002f },
    { -9.1424418e-001f, 4.0525657e-001f, -9.6701409e-003f, -2.2558731e-002f },
    { -9.2391432e-001f, 3.8269784e-001f, -9.1136094e-003f, -2.2789254e-002f },
    { -9.3302793e-001f, 3.5990859e-001f, -8.5515883e-003f, -2.3006049e-002f },
    { -9.4157951e-001f, 3.3690254e-001f, -7.9844160e-003f, -2.3208987e-002f },
    { -9.4956393e-001f, 3.1369355e-001f, -7.4124342e-003f, -2.3397944e-002f },
    { -9.5697637e-001f, 2.9029561e-001f, -6.8359874e-003f, -2.3572807e-002f },
    { -9.6381235e-001f, 2.6672280e-001f, -6.2554229e-003f, -2.3733471e-002f },
    { -9.7006778e-001f, 2.4298933e-001f, -5.6710904e-003f, -2.3879839e-002f },
    { -9.7573887e-001f, 2.1910949e-001f, -5.0833417e-003f, -2.4011822e-002f },
    { -9.8082221e-001f, 1.9509767e-001f, -4.4925311e-003f, -2.4129342e-002f },
    { -9.8531474e-001f, 1.7096833e-001f, -3.8990144e-003f, -2.4232327e-002f },
    { -9.8921375e-001f, 1.4673600e-001f, -3.3031490e-003f, -2.4320715e-002f },
    { -9.9251690e-001f, 1.2241528e-001f, -2.7052939e-003f, -2.4394453e-002f },
    { -9.9522220e-001f, 9.8020831e-002f, -2.1058093e-003f, -2.4453497e-002f },
    { -9.9732801e-001f, 7.3567333e-002f, -1.5050562e-003f, -2.4497812e-002f },
    { -9.9883306e-001f, 4.9069522e-002f, -9.0339650e-004f, -2.4527369e-002f },
    { -9.9973646e-001f, 2.4542153e-002f, -2.6354215e-004f, -2.4542153e-002f },
    { -1.0000000e+000f, 0.0000000e+000f, 2.6354215e-004f, -2.4542153e-002f },
    { -9.9973646e-001f, -2.4542153e-002f, 9.0339650e-004f, -2.4527369e-002f },
    { -9.9883306e-001f, -4.9069522e-002f, 1.5050562e-003f, -2.4497812e-002f },
    { -9.9732801e-001f, -7.3567333e-002f, 2.1058093e-003f, -2.4453497e-002f },
    { -9.9522220e-001f, -9.8020831e-002f, 2.7052939e-003f, -2.4394453e-002f },
    { -9.9251690e-001f, -1.2241528e-001f, 3.3031490e-003f, -2.4320715e-002f },
    { -9.8921375e-001f, -1.4673600e-001f, 3.8990144e-003f, -2.4232327e-002f },
    { -9.8531474e-001f, -1.7096833e-001f, 4.4925311e-003f, -2.4129342e-002f },
    { -9.8082221e-001f, -1.9509767e-001f, 5.0833417e-003f, -2.4011822e-002f },
    { -9.7573887e-001f, -2.1910949e-001f, 5.6710904e-003f, -2.3879839e-002f },
    { -9.7006778e-001f, -2.4298933e-001f, 6.2554229e-003f, -2.3733471e-002f },
    { -9.6381235e-001f, -2.6672280e-001f, 6.8359874e-003f, -2.3572807e-002f },
    { -9.5697637e-001f, -2.9029561e-001f, 7.4124342e-003f, -2.3397944e-002f },
    { -9.4956393e-001f, -3.1369355e-001f, 7.9844160e-003f, -2.3208987e-002f },
    { -9.4157951e-001f, -3.3690254e-001f, 8.5515883e-003f, -2.3006049e-002f },
    { -9.3302793e-001f, -3.5990859e-001f, 9.1136094e-003f, -2.2789254e-002f },
    { -9.2391432e-001f, -3.8269784e-001f, 9.6701409e-003f, -2.2558731e-002f },
    { -9.1424418e-001f, -4.0525657e-001f, 1.0220847e-002f, -2.2314620e-002f },
    { -9.0402333e-001f, -4.2757119e-001f, 1.0765397e-002f, -2.2057067e-002f },
    { -8.9325793e-001f, -4.4962826e-001f, 1.1303462e-002f, -2.1786227e-002f },
    { -8.8195447e-001f, -4.7141449e-001f, 1.1834719e-002f, -2.1502265e-002f },
    { -8.7011975e-001f, -4.9291675e-001f, 1.2358846e-002f, -2.1205350e-002f },
    { -8.5776090e-001f, -5.1412210e-001f, 1.2875530e-002f, -2.0895662e-002f },
    { -8.4488537e-001f, -5.3501776e-001f, 1.3384457e-002f, -2.0573388e-002f },
    { -8.3150092e-001f, -5.5559115e-001f, 1.3885322e-002f, -2.0238720e-002f },
    { -8.1761560e-001f, -5.7582987e-001f, 1.4377823e-002f, -1.9891862e-002f },
    { -8.0323777e-001f, -5.9572173e-001f, 1.4861663e-002f, -1.9533021e-002f },
    { -7.8837611e-001f, -6.1525475e-001f, 1.5336552e-002f, -1.9162415e-002f },
    { -7.7303956e-001f, -6.3441717e-001f, 1.5802202e-002f, -1.8780266e-002f },
    { -7.5723736e-001f, -6.5319744e-001f, 1.6258333e-002f, -1.8386804e-002f },
    { -7.4097902e-001f, -6.7158424e-001f, 1.6704671e-002f, -1.7982267e-002f },
    { -7.2427435e-001f, -6.8956651e-001f, 1.7140947e-002f, -1.7566898e-002f },
    { -7.0713340e-001f, -7.0713340e-001f, 1.7566898e-002f, -1.7140947e-002f },
    { -6.8956651e-001f, -7.2427435e-001f, 1.7982267e-002f, -1.6704671e-002f },
    { -6.7158424e-001f, -7.4097902e-001f, 1.8386804e-002f, -1.6258333e-002f },
    { -6.5319744e-001f, -7.5723736e-001f, 1.8780266e-002f, -1.5802202e-002f },
    { -6.3441717e-001f, -7.7303956e-001f, 1.9162415e-002f, -1.5336552e-002f },
    { -6.1525475e-001f, -7.8837611e-001f, 1.9533021e-002f, -1.4861663e-002f },
    { -5.9572173e-001f, -8.0323777e-001f, 1.9891862e-002f, -1.4377823e-002f },
    { -5.7582987e-001f, -8.1761560e-001f, 2.0238720e-002f, -1.3885322e-002f },
    { -5.5559115e-001f, -8.3150092e-001f, 2.0573388e-002f, -1.3384457e-002f },
    { -5.3501776e-001f, -8.4488537e-001f, 2.0895662e-002f, -1.2875530e-002f },
    { -5.1412210e-001f, -8.5776090e-001f, 2.1205350e-002f, -1.2358846e-002f },
    { -4.9291675e-001f, -8.7011975e-001f, 2.1502265e-002f, -1.1834719e-002f },
    { -4.7141449e-001f, -8.8195447e-001f, 2.1786227e-002f, -1.1303462e-002f },
    { -4.4962826e-001f, -8.9325793e-001f, 2.2057067e-002f, -1.0765397e-002f },
    { -4.2757119e-001f, -9.0402333e-001f, 2.2314620e-002f, -1.0220847e-002f },
    { -4.0525657e-001f, -9.1424418e-001f, 2.2558731e-002f, -9.6701409e-003f },
    { -3.8269784e-001f, -9.2391432e-001f, 2.2789254e-002f, -9.1136094e-003f },
    { -3.5990859e-001f, -9.3302793e-001f, 2.3006049e-002f, -8.5515883e-003f },
    { -3.3690254e-001f, -9.4157951e-001f, 2.3208987e-002f, -7.9844160e-003f },
    { -3.1369355e-001f, -9.4956393e-001f, 2.3397944e-002f, -7.4124342e-003f },
    { -2.9029561e-001f, -9.5697637e-001f, 2.3572807e-002f, -6.8359874e-003f },
    { -2.6672280e-001f, -9.6381235e-001f, 2.3733471e-002f, -6.2554229e-003f },
    { -2.4298933e-001f, -9.7006778e-001f, 2.3879839e-002f, -5.6710904e-003f },
    { -2.1910949e-001f, -9.7573887e-001f, 2.4011822e-002f, -5.0833417e-003f },
    { -1.9509767e-001f, -9.8082221e-001f, 2.4129342e-002f, -4.4925311e-003f },
    { -1.7096833e-001f, -9.8531474e-001f, 2.4232327e-002f, -3.8990144e-003f },
    { -1.4673600e-001f, -9.8921375e-001f, 2.4320715e-002f, -3.3031490e-003f },
    { -1.2241528e-001f, -9.9251690e-001f, 2.4394453e-002f, -2.7052939e-003f },
    { -9.8020831e-002f, -9.9522220e-001f, 2.4453497e-002f, -2.1058093e-003f },
    { -7.3567333e-002f, -9.9732801e-001f, 2.4497812e-002f, -1.5050562e-003f },
    { -4.9069522e-002f, -9.9883306e-001f, 2.4527369e-002f, -9.0339650e-004f },
    { -2.4542153e-002f, -9.9973646e-001f, 2.4542153e-002f, -2.6354215e-004f },
    { 0.0000000e+000f, -1.0000000e+000f, 2.4542153e-002f, 2.6354215e-004f },
    { 2.4542153e-002f, -9.9973646e-001f, 2.4527369e-002f, 9.0339650e-004f },
    { 4.9069522e-002f, -9.9883306e-001f, 2.4497812e-002f, 1.5050562e-003f },
    { 7.3567333e-002f, -9.9732801e-001f, 2.4453497e-002f, 2.1058093e-003f },
    { 9.8020831e-002f, -9.9522220e-001f, 2.4394453e-002f, 2.7052939e-003f },
    { 1.2241528e-001f, -9.9251690e-001f, 2.4320715e-002f, 3.3031490e-003f },
    { 1.4673600e-001f, -9.8921375e-001f, 2.4232327e-002f, 3.8990144e-003f },
    { 1.7096833e-001f, -9.8531474e-001f, 2.4129342e-002f, 4.4925311e-003f },
    { 1.9509767e-001f, -9.8082221e-001f, 2.4011822e-002f, 5.0833417e-003f },
    { 2.1910949e-001f, -9.7573887e-001f, 2.3879839e-002f, 5.6710904e-003f },
    { 2.4298933e-001f, -9.7006778e-001f, 2.3733471e-002f, 6.2554229e-003f },
    { 2.6672280e-001f, -9.6381235e-001f, 2.3572807e-002f, 6.8359874e-003f },
    { 2.9029561e-001f, -9.5697637e-001f, 2.3397944e-002f, 7.4124342e-003f },
    { 3.1369355e-001f, -9.4956393e-001f, 2.3208987e-002f, 7.9844160e-003f },
    { 3.3690254e-001f, -9.4157951e-001f, 2.3006049e-002f, 8.5515883e-003f },
    { 3.5990859e-001f, -9.3302793e-001f, 2.2789254e-002f, 9.1136094e-003f },
    { 3.8269784e-001f, -9.2391432e-001f, 2.2558731e-002f, 9.6701409e-003f },
    { 4.0525657e-001f, -9.1424418e-001f, 2.2314620e-002f, 1.0220847e-002f },
    { 4.2757119e-001f, -9.0402333e-001f, 2.2057067e-002f, 1.0765397e-002f },
    { 4.4962826e-001f, -8.9325793e-001f, 2.1786227e-002f, 1.1303462e-002f },
    { 4.7141449e-001f, -8.8195447e-001f, 2.1502265e-002f, 1.1834719e-002f },
    { 4.9291675e-001f, -8.7011975e-001f, 2.1205350e-002f, 1.2358846e-002f },
    { 5.1412210e-001f, -8.5776090e-001f, 2.0895662e-002f, 1.2875530e-002f },
    { 5.3501776e-001f, -8.4488537e-001f, 2.0573388e-002f, 1.3384457e-002f },
    { 5.5559115e-001f, -8.3150092e-001f, 2.0238720e-002f, 1.3885322e-002f },
    { 5.7582987e-001f, -8.1761560e-001f, 1.9891862e-002f, 1.4377823e-002f },
    { 5.9572173e-001f, -8.0323777e-001f, 1.9533021e-002f, 1.4861663e-002f },
    { 6.1525475e-001f, -7.8837611e-001f, 1.9162415e-002f, 1.5336552e-002f },
    { 6.3441717e-001f, -7.7303956e-001f, 1.8780266e-002f, 1.5802202e-002f },
    { 6.5319744e-001f, -7.5723736e-001f, 1.8386804e-002f, 1.6258333e-002f },
    { 6.7158424e-001f, -7.4097902e-001f, 1.7982267e-002f, 1.6704671e-002f },
    { 6.8956651e-001f, -7.2427435e-001f, 1.7566898e-002f, 1.7140947e-002f },
    { 7.0713340e-001f, -7.0713340e-001f, 1.7140947e-002f, 1.7566898e-002f },
    { 7.2427435e-001f, -6.8956651e-001f, 1.6704671e-002f, 1.7982267e-002f },
    { 7.4097902e-001f, -6.7158424e-001f, 1.6258333e-002f, 1.8386804e-002f },
    { 7.5723736e-001f, -6.5319744e-001f, 1.5802202e-002f, 1.8780266e-002f },
    { 7.7303956e-001f, -6.3441717e-001f, 1.5336552e-002f, 1.9162415e-002f },
    { 7.8837611e-001f, -6.1525475e-001f, 1.4861663e-002f, 1.9533021e-002f },
    { 8.0323777e-001f, -5.9572173e-001f, 1.4377823e-002f, 1.9891862e-002f },
    { 8.1761560e-001f, -5.7582987e-001f, 1.3885322e-002f, 2.0238720e-002f },
    { 8.3150092e-001f, -5.5559115e-001f, 1.3384457e-002f, 2.0573388e-002f },
    { 8.4488537e-001f, -5.3501776e-001f, 1.2875530e-002f, 2.0895662e-002f },
    { 8.5776090e-001f, -5.1412210e-001f, 1.2358846e-002f, 2.1205350e-002f },
    { 8.7011975e-001f, -4.9291675e-001f, 1.1834719e-002f, 2.1502265e-002f },
    { 8.8195447e-001f, -4.7141449e-001f, 1.1303462e-002f, 2.1786227e-002f },
    { 8.9325793e-001f, -4.4962826e-001f, 1.0765397e-002f, 2.2057067e-002f },
    { 9.0402333e-001f, -4.2757119e-001f, 1.0220847e-002f, 2.2314620e-002f },
    { 9.1424418e-001f, -4.0525657e-001f, 9.6701409e-003f, 2.2558731e-002f },
    { 9.2391432e-001f, -3.8269784e-001f, 9.1136094e-003f, 2.2789254e-002f },
    { 9.3302793e-001f, -3.5990859e-001f, 8.5515883e-003f, 2.3006049e-002f },
    { 9.4157951e-001f, -3.3690254e-001f, 7.9844160e-003f, 2.3208987e-002f },
    { 9.4956393e-001f, -3.1369355e-001f, 7.4124342e-003f, 2.3397944e-002f },
    { 9.5697637e-001f, -2.9029561e-001f, 6.8359874e-003f, 2.3572807e-002f },
    { 9.6381235e-001f, -2.6672280e-001f, 6.2554229e-003f, 2.3733471e-002f },
    { 9.7006778e-001f, -2.4298933e-001f, 5.6710904e-003f, 2.3879839e-002f },
    { 9.7573887e-001f, -2.1910949e-001f, 5.0833417e-003f, 2.4011822e-002f },
    { 9.8082221e-001f, -1.9509767e-001f, 4.4925311e-003f, 2.4129342e-002f },
    { 9.8531474e-001f, -1.7096833e-001f, 3.8990144e-003f, 2.4232327e-002f },
    { 9.8921375e-001f, -1.4673600e-001f, 3.3031490e-003f, 2.4320715e-002f },
    { 9.9251690e-001f, -1.2241528e-001f, 2.7052939e-003f, 2.4394453e-002f },
    { 9.9522220e-001f, -9.8020831e-002f, 2.1058093e-003f, 2.4453497e-002f },
    { 9.9732801e-001f, -7.3567333e-002f, 1.5050562e-003f, 2.4497812e-002f },
    { 9.9883306e-001f, -4.9069522e-002f, 9.0339650e-004f, 2.4527369e-002f },
    { 9.9973646e-001f, -2.4542153e-002f, 2.6354215e-004f, 2.4542153e-002f }
};

const AtanSample AtanSampleTable[128 + 1] =
{
    { 0x0, 5340245.f }, // tan = 0.0
    { 0x517c55, 5339593.f }, // tan = 0.0078125
    { 0xa2f61e, 5338290.f }, // tan = 0.015625
    { 0xf46ad0, 5336337.f }, // tan = 0.0234375
    { 0x145d7e1, 5333734.f }, // tan = 0.03125
    { 0x1973ac7, 5330485.f }, // tan = 0.0390625
    { 0x1e890fc, 5326591.f }, // tan = 0.046875
    { 0x239d7fb, 5322056.f }, // tan = 0.0546875
    { 0x28b0d43, 5316880.f }, // tan = 0.0625
    { 0x2dc2e53, 5311072.f }, // tan = 0.0703125
    { 0x32d38b3, 5304632.f }, // tan = 0.078125
    { 0x37e29eb, 5297566.f }, // tan = 0.0859375
    { 0x3ceff89, 5289880.f }, // tan = 0.09375
    { 0x41fb721, 5281577.f }, // tan = 0.1015625
    { 0x4704e4a, 5272666.f }, // tan = 0.109375
    { 0x4c0c2a4, 5263152.f }, // tan = 0.1171875
    { 0x51111d4, 5253040.f }, // tan = 0.125
    { 0x5613984, 5242339.f }, // tan = 0.1328125
    { 0x5b13767, 5231056.f }, // tan = 0.140625
    { 0x6010937, 5219199.f }, // tan = 0.1484375
    { 0x650acb6, 5206776.f }, // tan = 0.15625
    { 0x6a01fae, 5193795.f }, // tan = 0.1640625
    { 0x6ef5ff1, 5180265.f }, // tan = 0.171875
    { 0x73e6b5a, 5166196.f }, // tan = 0.1796875
    { 0x78d3fce, 5151596.f }, // tan = 0.1875
    { 0x7dbdb3a, 5136474.f }, // tan = 0.1953125
    { 0x82a3b94, 5120843.f }, // tan = 0.203125
    { 0x8785edf, 5104710.f }, // tan = 0.2109375
    { 0x8c64325, 5088087.f }, // tan = 0.21875
    { 0x913e67c, 5070983.f }, // tan = 0.2265625
    { 0x9614703, 5053411.f }, // tan = 0.234375
    { 0x9ae62e6, 5035381.f }, // tan = 0.2421875
    { 0x9fb385b, 5016903.f }, // tan = 0.25
    { 0xa47c5a2, 4997989.f }, // tan = 0.2578125
    { 0xa940907, 4978650.f }, // tan = 0.265625
    { 0xae000e1, 4958900.f }, // tan = 0.2734375
    { 0xb2bab95, 4938746.f }, // tan = 0.28125
    { 0xb77078f, 4918204.f }, // tan = 0.2890625
    { 0xbc2134b, 4897283.f }, // tan = 0.296875
    { 0xc0ccd4e, 4875996.f }, // tan = 0.3046875
    { 0xc57342a, 4854354.f }, // tan = 0.3125
    { 0xca1467c, 4832371.f }, // tan = 0.3203125
    { 0xceb02ef, 4810055.f }, // tan = 0.328125
    { 0xd346836, 4787422.f }, // tan = 0.3359375
    { 0xd7d7514, 4764482.f }, // tan = 0.34375
    { 0xdc62856, 4741246.f }, // tan = 0.3515625
    { 0xe0e80d4, 4717727.f }, // tan = 0.359375
    { 0xe567d73, 4693937.f }, // tan = 0.3671875
    { 0xe9e1d24, 4669886.f }, // tan = 0.375
    { 0xee55ee2, 4645588.f }, // tan = 0.3828125
    { 0xf2c41b6, 4621054.f }, // tan = 0.390625
    { 0xf72c4b4, 4596293.f }, // tan = 0.3984375
    { 0xfb8e6f9, 4571319.f }, // tan = 0.40625
    { 0xffea7b0, 4546143.f }, // tan = 0.4140625
    { 0x1044060f, 4520775.f }, // tan = 0.421875
    { 0x10890156, 4495227.f }, // tan = 0.4296875
    { 0x10cd98d1, 4469509.f }, // tan = 0.4375
    { 0x1111cbd6, 4443632.f }, // tan = 0.4453125
    { 0x115599c6, 4417608.f }, // tan = 0.453125
    { 0x1199020e, 4391445.f }, // tan = 0.4609375
    { 0x11dc0423, 4365155.f }, // tan = 0.46875
    { 0x121e9f86, 4338747.f }, // tan = 0.4765625
    { 0x1260d3c1, 4312233.f }, // tan = 0.484375
    { 0x12a2a06a, 4285619.f }, // tan = 0.4921875
    { 0x12e4051d, 4258919.f }, // tan = 0.5
    { 0x13250184, 4232138.f }, // tan = 0.5078125
    { 0x1365954e, 4205290.f }, // tan = 0.515625
    { 0x13a5c038, 4178379.f }, // tan = 0.5234375
    { 0x13e58203, 4151418.f }, // tan = 0.53125
    { 0x1424da7d, 4124413.f }, // tan = 0.5390625
    { 0x1463c97a, 4097373.f }, // tan = 0.546875
    { 0x14a24ed7, 4070307.f }, // tan = 0.5546875
    { 0x14e06a7a, 4043223.f }, // tan = 0.5625
    { 0x151e1c51, 4016127.f }, // tan = 0.5703125
    { 0x155b6450, 3989029.f }, // tan = 0.578125
    { 0x15984275, 3961935.f }, // tan = 0.5859375
    { 0x15d4b6c4, 3934853.f }, // tan = 0.59375
    { 0x1610c149, 3907789.f }, // tan = 0.6015625
    { 0x164c6216, 3880751.f }, // tan = 0.609375
    { 0x16879945, 3853745.f }, // tan = 0.6171875
    { 0x16c266f6, 3826778.f }, // tan = 0.625
    { 0x16fccb50, 3799855.f }, // tan = 0.6328125
    { 0x1736c67f, 3772982.f }, // tan = 0.640625
    { 0x177058b5, 3746167.f }, // tan = 0.6484375
    { 0x17a9822c, 3719414.f }, // tan = 0.65625
    { 0x17e24322, 3692729.f }, // tan = 0.6640625
    { 0x181a9bdb, 3666115.f }, // tan = 0.671875
    { 0x18528c9e, 3639581.f }, // tan = 0.6796875
    { 0x188a15bb, 3613130.f }, // tan = 0.6875
    { 0x18c13785, 3586765.f }, // tan = 0.6953125
    { 0x18f7f252, 3560493.f }, // tan = 0.703125
    { 0x192e467f, 3534318.f }, // tan = 0.7109375
    { 0x1964346d, 3508243.f }, // tan = 0.71875
    { 0x1999bc80, 3482274.f }, // tan = 0.7265625
    { 0x19cedf22, 3456412.f }, // tan = 0.734375
    { 0x1a039cbe, 3430662.f }, // tan = 0.7421875
    { 0x1a37f5c4, 3405030.f }, // tan = 0.75
    { 0x1a6beaaa, 3379514.f }, // tan = 0.7578125
    { 0x1a9f7be4, 3354123.f }, // tan = 0.765625
    { 0x1ad2a9ef, 3328857.f }, // tan = 0.7734375
    { 0x1b057548, 3303718.f }, // tan = 0.78125
    { 0x1b37de6e, 3278711.f }, // tan = 0.7890625
    { 0x1b69e5e5, 3253838.f }, // tan = 0.796875
    { 0x1b9b8c33, 3229100.f }, // tan = 0.8046875
    { 0x1bccd1df, 3204502.f }, // tan = 0.8125
    { 0x1bfdb775, 3180044.f }, // tan = 0.8203125
    { 0x1c2e3d81, 3155729.f }, // tan = 0.828125
    { 0x1c5e6492, 3131558.f }, // tan = 0.8359375
    { 0x1c8e2d38, 3107535.f }, // tan = 0.84375
    { 0x1cbd9807, 3083660.f }, // tan = 0.8515625
    { 0x1ceca593, 3059934.f }, // tan = 0.859375
    { 0x1d1b5671, 3036361.f }, // tan = 0.8671875
    { 0x1d49ab3a, 3012941.f }, // tan = 0.875
    { 0x1d77a487, 2989674.f }, // tan = 0.8828125
    { 0x1da542f1, 2966562.f }, // tan = 0.890625
    { 0x1dd28713, 2943609.f }, // tan = 0.8984375
    { 0x1dff718c, 2920811.f }, // tan = 0.90625
    { 0x1e2c02f7, 2898173.f }, // tan = 0.9140625
    { 0x1e583bf4, 2875693.f }, // tan = 0.921875
    { 0x1e841d21, 2853373.f }, // tan = 0.9296875
    { 0x1eafa71e, 2831215.f }, // tan = 0.9375
    { 0x1edada8d, 2809217.f }, // tan = 0.9453125
    { 0x1f05b80e, 2787380.f }, // tan = 0.953125
    { 0x1f304042, 2765706.f }, // tan = 0.9609375
    { 0x1f5a73cc, 2744194.f }, // tan = 0.96875
    { 0x1f84534e, 2722845.f }, // tan = 0.9765625
    { 0x1faddf6b, 2701658.f }, // tan = 0.984375
    { 0x1fd718c5, 2680635.f }, // tan = 0.9921875
    { 0x20000000, 2659773.f }, // tan = 1.0
};

}}}
