﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_SdkLog.h>

/**
    @file JPEG ライブラリの各種設定を行うためのファイル
 */


/**
    @brief      Exifメタ情報として、符号付き整数/分数をサポートするかどうかのフラグ。
    @details    Extractor/Builder でそのようなタグの取得/設定を行わないのであれば、
                サポートしなくてもよいが、積極的に非サポートとする理由もない。
                非サポートの場合は undef する。
*/
#define NN_DETAIL_IMAGE_JPEG_CONFIG_EXIF_SIGNED_VALUE_SUPPORTED

/**
    @brief      JPEG ライブラリのログ出力レベル。
    @details    0 ... ログを出力しない
                1 ... エラー時の問題の個所や、JPEG/Exifデータの統計情報を表示
                2 ... JPEG/Exifデータの詳細を表示
 */
#define NN_DETAIL_IMAGE_JPEG_CONFIG_DEBUG_PRINT (0)

#if NN_DETAIL_IMAGE_JPEG_CONFIG_DEBUG_PRINT >= 1
// エラーを示す。基本的にエラーのあとは処理を中止すること。
#define NN_DETAIL_IMAGE_JPEG_LOG_ERROR(...) NN_SDK_LOG("[nn::image(jpeg)] ! " __VA_ARGS__)
// 警告を示す。意図しない状況ではあるものの、処理を中止してはいけない。
#define NN_DETAIL_IMAGE_JPEG_LOG_WARN(...)  NN_SDK_LOG("[nn::image(jpeg)] ? " __VA_ARGS__)
// 情報を示す。意図通りの挙動。
#define NN_DETAIL_IMAGE_JPEG_LOG_INFO(...)  NN_SDK_LOG("[nn::image(jpeg)] - " __VA_ARGS__)
#if NN_DETAIL_IMAGE_JPEG_CONFIG_DEBUG_PRINT >= 2
// JPEGライブラリ開発者にのみ有益な情報を出力すること。
#define NN_DETAIL_IMAGE_JPEG_LOG_DETAIL(...) NN_SDK_LOG("[nn::image(jpeg)]   " __VA_ARGS__)
#else
#define NN_DETAIL_IMAGE_JPEG_LOG_DETAIL(...) static_cast<void>((__VA_ARGS__))
#endif
#else
#define NN_DETAIL_IMAGE_JPEG_LOG_ERROR(...)
#define NN_DETAIL_IMAGE_JPEG_LOG_WARN(...)
#define NN_DETAIL_IMAGE_JPEG_LOG_INFO(...)
#define NN_DETAIL_IMAGE_JPEG_LOG_DETAIL(...)
#endif
