﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/edid/edid_Audio.h>
#include <nn/edid/edid_AudioFormatInfo.h>
#include <nn/edid/edid_Edid.h>
#include "detail/edid_AudioMode.h"

void nn::edid::VisitAudioFormats(const Edid* pEdid, AudioFormatVisitor visitor, void* pUserData) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pEdid);
    NN_SDK_REQUIRES_NOT_NULL(visitor);

    nn::edid::detail::AudioFormatVisitorData visitorData;
    visitorData.visitor = visitor;
    visitorData.pUserData = pUserData;
    nn::edid::cea861::VisitBlocks(pEdid, detail::AudioDataVisitor, &visitorData);

}

bool nn::edid::GetAudioFormatBitRateMax(int* pOutBitRate, const AudioFormatInfo* pFormat) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutBitRate);
    NN_SDK_REQUIRES_NOT_NULL(pFormat);

    NN_UNUSED(pOutBitRate);
    NN_UNUSED(pFormat);

    return false;
}

bool nn::edid::GetAudioFormatBitDepth(int* pOutBitDepth, const AudioFormatInfo* pFormat) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutBitDepth);
    NN_SDK_REQUIRES_NOT_NULL(pFormat);

    NN_UNUSED(pOutBitDepth);
    NN_UNUSED(pFormat);

    return false;
}

nn::edid::SpeakerAllocationSet nn::edid::GetSpeakerAllocation(const Edid* pEdid) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pEdid);

    NN_UNUSED(pEdid);

    return SpeakerAllocationSet();
}

bool nn::edid::IsAudioSupported(const Edid* pEdid) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pEdid);

    NN_UNUSED(pEdid);

    return false;
}
